package com.xforceplus.phoenix.tools.enums;

import com.xforceplus.phoenix.tools.enums.base.IEnumStringValue;

/**
 * @program: phoenix-purchaser-tools
 * @description: 税件返回状态码
 * @author: cuixiangyu
 * @created: 2020-05-15 16:36
 */
public enum TaxWareStatusEnum implements IEnumStringValue {

    RESULT_SUCCESS("TXWR000000","成功"),

    AUTH_SUCCESS("TXWRAU0001","发票勾选成功"),

    AUTH_ING("TXWRAU0002","勾选请求处理中"),

    AUTH_FAIL("TXWRAU0009","发票勾选失败"),

    VERIFY_SUCCESS("TXWRVC0001","成功"),

    VERIFY_ING("TXWRVC0204","验真中"),

    VERIFY_NO_TASK("TXWRVC0400","不存在相应的任务号,请检查后再试"),

    VERIFY_INVALID_PARAM("TXWRVC5000","验真参数不合法"),

    VERIFY_NO_INVOICE("TXWRVC5001","查无此票"),

    VERIFY_NO_SAME("TXWRVC5002","不一致"),

    VERIFY_OVER_TIMES("TXWRVC5003","超过该张发票当日查验次数"),

    VERIFY_NATION_UPGRADE("TXWRVC5010","国税系统升级中,请稍后再试！"),

    VERIFY_NATION_EXCEPTION("TXWRVC5011","国税异常、请重试"),

    VERIFY_FAIL_SIGN("TXWRVC5102","签章验证不通过"),

    VERIFY_UNSUPPORT_TYPE("TXWRVC5103","暂不支持该票种查验"),

    VERIFY_INVALID_OFD("TXWRVC9000","非法发票ofd文件"),

    VERIFY_EXCEPTION("TXWRVC9999","处理异常、请稍后重试"),
    ;

    private final String value;
    private final String description;

    TaxWareStatusEnum(String value, String description) {
        this.value = value;
        this.description = description;
    }

    @Override
    public String value() {
        return this.value;
    }

    public String getDescription() {
        return description;
    }
}
