package com.xforceplus.phoenix.tools.enums;

import com.xforceplus.phoenix.tools.enums.base.IEnumIntValue;

/**
 * @program: phoenix-purchaser-tools
 * @description: 转出状态枚举
 * @author: cuixiangyu
 * @created: 2020-05-06 17:08
 */
public enum TurnOutStatusEnum implements IEnumIntValue {

    /**
     * 未转出
     */
    NO_TURN_OUT(0,"未转出"),
    /**
     * 部分转出
     */
    PART_TURN_OUT(1,"部分转出"),
    /**
     * 已转出
     */
    COMPLETE_TURN_OUT(2,"已转出"),
    ;

    private final Integer value;
    private final String description;

    TurnOutStatusEnum(Integer value, String description) {
        this.value = value;
        this.description = description;
    }

    @Override
    public Integer value() {
        return this.value;
    }

    public String getDescription() {
        return description;
    }
}
