package com.xforceplus.phoenix.tools.enums.base;

import org.apache.commons.lang3.EnumUtils;

import java.util.Objects;

/**
 * 枚举基类
 *
 * @author: wdye
 * @created: 2019-09-18 10:23
 */
public interface IEnumValue<T> {

    /**
     * 值
     *
     * @return
     */
    T value();

    /**
     * 根据值获取枚举
     *
     * @param enumClass
     * @param value
     * @param def
     * @param <E>
     * @param <T>
     * @return
     */
    static <E extends Enum<E> & IEnumValue<T>, T> E fromValue(Class<E> enumClass, T value, E def) {
        return (null == value) ? def : EnumUtils.getEnumList(enumClass).stream().filter(p -> value.equals(p.value())).findFirst().orElse(def);
    }

    /**
     * 根据值获取枚举未匹配到返回null
     *
     * @param enumClass
     * @param value
     * @param <E>
     * @param <T>
     * @return
     */
    static <E extends Enum<E> & IEnumValue<T>, T> E fromValue(Class<E> enumClass, T value) {
        return fromValue(enumClass, value, null);
    }

    /**
     * 值比较
     *
     * @param anotherValue
     * @return
     */
    default boolean isValueEquals(T anotherValue) {
        return Objects.equals(value(), anotherValue);
    }

    /**
     * 值比较
     *
     * @param anotherValue
     * @return
     */
    default boolean isValueNotEquals(T anotherValue) {
        return !isValueEquals(anotherValue);
    }
}
