package com.xforceplus.phoenix.tools.function;

/**
 * @program: phoenix-purchaser-tools
 * @description 执行监听
 * @author: wdye
 * @created: 2020-07-07 13:58
 */
public interface ExecuteListener<R> {
    /**
     * 发生异常是否抛出
     *
     * @return
     */
    default boolean isThrow() {
        return true;
    }

    /**
     * 发生异常时执行
     *
     * @param e
     * @param r
     */
    void exception(Exception e, R r);

    /**
     * 最后执行
     *
     * @param r
     */
    default void last(R r) {
    }
}
