package com.xforceplus.phoenix.tools.logger;

import org.apache.commons.lang3.StringUtils;

/**
 * @program: phoenix-purchaser-tools
 * @description
 * @author: wdye
 * @created: 2020-02-03 12:32
 */
public abstract class AbstractBaseLogger {

    protected static final String COMMA = ",";

    /**
     * 业务唯一标识号或结算单号
     */
    protected String businessNo = StringUtils.EMPTY;
    /**
     * 租户号
     */
    protected String tenantNo = StringUtils.EMPTY;
    /**
     * 公司代码
     */
    protected String companyCode = StringUtils.EMPTY;
    /**
     * 消息
     */
    protected String message = StringUtils.EMPTY;

    public AbstractBaseLogger businessNo(String businessNo) {
        this.businessNo = businessNo;
        return this;
    }

    public AbstractBaseLogger tenantNo(String tenantNo) {
        this.tenantNo = tenantNo;
        return this;
    }

    public AbstractBaseLogger companyCode(String companyCode) {
        this.companyCode = companyCode;
        return this;
    }

    public AbstractBaseLogger message(String message) {
        this.message = message;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("businessNo=").append(businessNo).append(COMMA);
        stringBuilder.append("tenantNo=").append(tenantNo).append(COMMA);
        stringBuilder.append("companyCode=").append(companyCode).append(COMMA);
        stringBuilder.append("message=").append(message).append(COMMA);
        return stringBuilder.toString();
    }
}
