package com.xforceplus.phoenix.tools.transaction.consumer;

import java.util.Objects;

/**
 * @program: phoenix-purchaser-tools
 * @description
 * @author: wdye
 * @created: 2020-01-14 14:11
 */
@FunctionalInterface
public interface Consumer2<A1, A2> {
    /**
     * 接收2个参数
     *
     * @param var1
     * @param var2
     */
    void accept(A1 var1, A2 var2);

    /**
     * 在Accept后面执行
     *
     * @param after
     * @return
     */
    default Consumer2<A1, A2> andThen(Consumer2<? super A1, ? super A2> after) {
        Objects.requireNonNull(after);
        return (A1 a1, A2 a2) -> {
            accept(a1, a2);
            after.accept(a1, a2);
        };
    }
}
