package com.xforceplus.phoenix.tools.transaction.event;

import com.xforceplus.phoenix.tools.transaction.util.FunctionUtil;
import org.springframework.context.ApplicationEvent;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

/**
 * @program: phoenix-purchaser-tools
 * @description
 * @author: wdye
 * @created: 2019-11-01 10:29
 */
public class BaseAfterCommitCallEvent extends ApplicationEvent {
    private Object handler;
    private List args;
    private boolean isFunction;

    public BaseAfterCommitCallEvent(Object handler, List args) {
        super(handler);
        this.handler = handler;
        this.args = args;
        if (!(handler instanceof Supplier) && !(handler instanceof Function) && !(handler instanceof BiFunction)) {
            if (!(handler instanceof Runnable) && !(handler instanceof Consumer)) {
                throw new UnsupportedOperationException();
            }
            this.isFunction = false;
        } else {
            this.isFunction = true;
        }
    }

    public void call() {
        if (this.isFunction) {
            FunctionUtil.callFunction(this.handler, this.args);
        } else {
            FunctionUtil.callConsumer(this.handler, this.args);
        }
    }

    public Object getHandler() {
        return this.handler;
    }

    public List getArgs() {
        return this.args;
    }
}
