package com.xforceplus.phoenix.tools.transaction.impl;

import com.xforceplus.phoenix.tools.exception.LockException;
import com.xforceplus.phoenix.tools.transaction.TransactionServiceInvoker;
import com.xforceplus.phoenix.tools.transaction.consumer.Consumer2;
import com.xforceplus.phoenix.tools.transaction.consumer.Function3;
import com.xforceplus.phoenix.tools.transaction.consumer.Function4;
import com.xforceplus.phoenix.tools.transaction.consumer.Function5;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

/**
 * @program: phoenix-purchaser-tools
 * @description
 * @author: wdye
 * @created: 2019-10-28 17:55
 */
@Slf4j
@Component
public class DefaultTransactionServiceInvokerImpl implements TransactionServiceInvoker {

    @Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = RuntimeException.class)
    @Override
    public void callNewTx(Runnable runnable) {
        runnable.run();
    }

    @Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = RuntimeException.class)
    @Override
    public void callNewTx(Runnable runnable, Long lockLeaseTime) {
        long lockExpired = System.currentTimeMillis() + lockLeaseTime;
        runnable.run();
        rollbackWhenLockTimeout(lockExpired, lockLeaseTime);
    }

    @Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = RuntimeException.class)
    @Override
    public <A1> void callNewTx(Consumer<A1> consumer, A1 arg1) {
        consumer.accept(arg1);
    }

    @Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = RuntimeException.class)
    @Override
    public <A1> void callNewTx(Consumer<A1> consumer, A1 arg1, Long lockLeaseTime) {
        long lockExpired = System.currentTimeMillis() + lockLeaseTime;
        consumer.accept(arg1);
        rollbackWhenLockTimeout(lockExpired, lockLeaseTime);
    }

    @Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = RuntimeException.class)
    @Override
    public <R> R callNewTx(Supplier<R> supplier) {
        R r = supplier.get();
        return r;
    }

    @Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = RuntimeException.class)
    @Override
    public <R> R callNewTx(Supplier<R> supplier, Long lockLeaseTime) {
        long lockExpired = System.currentTimeMillis() + lockLeaseTime;
        R r = supplier.get();
        rollbackWhenLockTimeout(lockExpired, lockLeaseTime);
        return r;
    }

    @Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = RuntimeException.class)
    @Override
    public <A1, R> R callNewTx(Function<A1, R> function, A1 arg1) {
        R r = function.apply(arg1);
        return r;
    }

    @Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = RuntimeException.class)
    @Override
    public <A1, R> R callNewTx(Function<A1, R> function, A1 arg1, Long lockLeaseTime) {
        long lockExpired = System.currentTimeMillis() + lockLeaseTime;
        R r = function.apply(arg1);
        rollbackWhenLockTimeout(lockExpired, lockLeaseTime);
        return r;
    }

    @Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = RuntimeException.class)
    @Override
    public <A1, A2, R> R callNewTx(BiFunction<A1, A2, R> biFunction, A1 arg1, A2 arg2) {
        R r = biFunction.apply(arg1, arg2);
        return r;
    }

    @Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = RuntimeException.class)
    @Override
    public <A1, A2, A3, R> R callNewTx(Function3<A1, A2, A3, R> function3, A1 arg1, A2 arg2, A3 arg3) {
        R r = function3.apply(arg1, arg2, arg3);
        return r;
    }

    @Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = RuntimeException.class)
    @Override
    public <A1, A2, A3, A4, R> R callNewTx(Function4<A1, A2, A3, A4, R> function4, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        R r = function4.apply(arg1, arg2, arg3, arg4);
        return r;
    }

    @Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = RuntimeException.class)
    @Override
    public <A1, A2, A3, A4, A5, R> R callNewTx(Function5<A1, A2, A3, A4, A5, R> function5, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        R r = function5.apply(arg1, arg2, arg3, arg4, arg5);
        return r;
    }

    @Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = RuntimeException.class)
    @Override
    public <A1, A2, R> R callNewTx(BiFunction<A1, A2, R> biFunction, A1 arg1, A2 arg2, Long lockLeaseTime) {
        long lockExpired = System.currentTimeMillis() + lockLeaseTime;
        R r = biFunction.apply(arg1, arg2);
        rollbackWhenLockTimeout(lockExpired, lockLeaseTime);
        return r;
    }

    @Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = RuntimeException.class)
    @Override
    public <A1, A2, A3, R> R callNewTx(Function3<A1, A2, A3, R> function3, A1 arg1, A2 arg2, A3 arg3, Long lockLeaseTime) {
        long lockExpired = System.currentTimeMillis() + lockLeaseTime;
        R r = function3.apply(arg1, arg2, arg3);
        rollbackWhenLockTimeout(lockExpired, lockLeaseTime);
        return r;
    }

    @Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = RuntimeException.class)
    @Override
    public <A1, A2> void callNewTx(Consumer2<A1, A2> consumer2, A1 var1, A2 var2) {
        consumer2.accept(var1, var2);
    }

    @Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = RuntimeException.class)
    @Override
    public <A1, A2> void callNewTx(Consumer2<A1, A2> consumer2, A1 var1, A2 var2, Long lockLeaseTime) {
        long lockExpired = System.currentTimeMillis() + lockLeaseTime;
        consumer2.accept(var1, var2);
        rollbackWhenLockTimeout(lockExpired, lockLeaseTime);
    }

    @Async
    @Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = RuntimeException.class)
    @Override
    public void callNewAsyncTx(Runnable runnable) {
        runnable.run();
    }

    @Async
    @Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = RuntimeException.class)
    @Override
    public void callNewAsyncTx(Runnable runnable, Long lockLeaseTime) {
        long lockExpired = System.currentTimeMillis() + lockLeaseTime;
        runnable.run();
        rollbackWhenLockTimeout(lockExpired, lockLeaseTime);
    }

    private void rollbackWhenLockTimeout(long lockExpired, long lockLeaseTime) {
        if (System.currentTimeMillis() - lockLeaseTime > lockExpired) {
            String err = String.format("锁: 超时! 事务回滚");
            throw new LockException(err);
        }
    }
}
