package com.xforceplus.phoenix.tools.util;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;

/**
 * @program: phoenix-purchaser-tools
 * @description: mapstruct的string转换时判定校验
 * @author: cuixiangyu
 * @created: 2020-07-02 14:06
 */
@Component
public class CommonMapper {

    public BigDecimal stringToBigDecimal(String str){
        return StringUtils.isEmpty(str) || StringUtils.isBlank(str) ? null : new BigDecimal(str);
    }

    public Integer stringToInteger(String str){
        return StringUtils.isEmpty(str) || StringUtils.isBlank(str) ? null : Integer.parseInt(str);
    }

    public Long stringToLong(String str){
        return StringUtils.isEmpty(str) || StringUtils.isBlank(str) ? null : Long.parseLong(str);
    }
}
