package com.xforceplus.phoenix.tools.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

/**
 * @program: phoenix-purchaser-tools
 * @description 日期工具类
 * @author: liuda
 * @created: 2020-04-16 11:07
 */
public class DateUtil {
    public static final String DATE_YEAR_MONTH = "yyyyMM";

    /**
     * 根据传入的格式返回当前时间
     * @param format
     * @return
     */
    public static String getCurDateTime(String format) {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
        String dataTime = now.format(dateTimeFormatter);
        return dataTime;
    }

    /**
     * 根据传入的月份获取下一个月
     * @param month
     * @return
     */
    public static String nextMonth(String month){
        String result = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
            Date date = sdf.parse(month);
            Instant instant = date.toInstant();
            ZoneId zone = ZoneId.systemDefault();
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
            LocalDate localDate = localDateTime.toLocalDate();
            result = localDate.plusMonths(1).format(DateTimeFormatter.ofPattern("yyyyMM"));
        } catch (ParseException var2) {
            var2.printStackTrace();
        }
        return result;
    }
    /**
     * 根据传入的月份获取上一个月
     * @param month
     * @return
     */
    public static String lastMonth(String month) {
        String result = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
            Date date = sdf.parse(month);
            Instant instant = date.toInstant();
            ZoneId zone = ZoneId.systemDefault();
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
            LocalDate localDate = localDateTime.toLocalDate();
            result = localDate.minusMonths(1).format(DateTimeFormatter.ofPattern("yyyyMM"));
        } catch (ParseException var2) {
            var2.printStackTrace();
        }
        return result;
    }
}
