package com.xforceplus.phoenix.tools.util;

import com.xforceplus.phoenix.tools.enums.FileTypeDictEnum;
import lombok.extern.slf4j.Slf4j;

import javax.net.ssl.*;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;

/**
 * @program: phoenix-purchaser-tools
 * @description 文件工具类
 * @author: liuda
 * @created: 2020-05-13 9:35
 */
@Slf4j
public final class FileUtil {
    private FileUtil() {
    }

    public static boolean createFile(String destFileName) {
        File file = new File(destFileName);
        if (file.exists()) {
            return false;
        } else if (destFileName.endsWith(File.separator)) {
            return false;
        } else {
            if (!file.getParentFile().exists()) {
                if (!file.getParentFile().mkdirs()) {
                    return false;
                }
            }
            try {
                if (file.createNewFile()) {
                    return true;
                } else {
                    return false;
                }
            } catch (IOException e) {
                log.error("{}", e);
                return false;
            }
        }
    }
    /**
     * 根据外网文件地址转成Base64
     * @param fileUrl
     * @return
     */
    public static String requestUrlToBase64(String fileUrl) {
        String result = null;
        HttpURLConnection connection = null;
        try {
            if(fileUrl.contains("https")){
                SSLContext sslcontext = SSLContext.getInstance("SSL","SunJSSE");
                sslcontext.init(null, new TrustManager[]{new FileX509TrustManager()}, new java.security.SecureRandom());
                HostnameVerifier ignoreHostnameVerifier = (String s, SSLSession sslsession) -> {return true;};
                HttpsURLConnection.setDefaultHostnameVerifier(ignoreHostnameVerifier);
                HttpsURLConnection.setDefaultSSLSocketFactory(sslcontext.getSocketFactory());
            }
            URL url = new URL(fileUrl);
            connection = (HttpURLConnection) url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            // 获取请求输入流
            InputStream inputStream = connection.getInputStream();
            // inputStream流数据转ByteArrayOutputStream
            int len = -1;
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((len = inputStream.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            // ByteArrayOutputStream编码成base64字符串
            result = new String(Base64.getEncoder().encode(out.toByteArray()));
            connection.disconnect();
        } catch (Exception e) {
            e.printStackTrace();
        }finally{
            if(connection != null){
                connection.disconnect();
            }
        }
        return result;
    }

    /**
     * 根据输入流判断文件后缀
     *
     * @param inputStream
     * @return
     * @throws Exception
     */
    public static String getFileSuffix(InputStream inputStream) throws Exception{
        byte[] b = new byte[8];
        inputStream.read(b, 0, b.length);

        StringBuilder stringBuilder = new StringBuilder();
        if (b == null || b.length <= 0) {
            return null;
        }
        for (int i = 0; i < b.length; i++) {
            int v = b[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        String fileHeader = stringBuilder.toString().toUpperCase();
        return FileTypeDictEnum.checkType(fileHeader);
    }
}
