package com.xforceplus.phoenix.tools.util;

import com.google.common.base.Splitter;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.util.StringUtil;

import java.math.BigDecimal;

/**
 * @author liuda
 * @version 1.0
 * @date 2020/1/13 14:46
 * 发票工具类
 */
public class InvoiceUtil {


    /**
     * 根据发票明细上货物或应税劳务名称截取税编简称
     *
     * @param str
     * @return
     */
    public static String getTaxShort(String str) {
        final String chineseReg = "[\\u4e00-\\u9fa5]+";
        if (StringUtils.isEmpty(str)) {
            return StringUtils.EMPTY;
        }
        Iterable<String> splits = Splitter.on('*').omitEmptyStrings().split(str);
        if (splits.iterator().next().matches(chineseReg)) {
            return splits.iterator().next();
        }
        return StringUtils.EMPTY;
    }

    /**
     * 将税率5%转换成0.05
     *
     * @param str
     * @return
     */
    public static BigDecimal getTaxRate(String str) {
        if (StringUtils.isEmpty(str)) {
            return BigDecimal.ZERO;
        }
        String[] split = str.split(",");
        if (split.length != 1) {
            return BigDecimal.ZERO;
        }
        String replace = str.replace("%", "");
        return new BigDecimal(replace).multiply(new BigDecimal("0.01"));
    }

    /**
     * 获取商品名称，格式为 *蔬菜*水果 的水果
     *
     * @param str
     * @return
     */
    public static String getCargoName(String str) {
        if (StringUtils.isEmpty(str)) {
            return StringUtils.EMPTY;
        }
        String starMark = "*";
        if (str.startsWith(starMark)) {
            str = str.substring(1);
            str = str.substring(str.indexOf(starMark) + starMark.length());
        }
        return str;
    }
}
