package com.xforceplus.phoenix.tools.util;

import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;

/**
 * @program: phoenix-purchaser-tools
 * @description
 * @author: wdye
 * @created: 2020-01-16 17:56
 */
public class NumberUtil {

    /**
     * 数字转{@link BigDecimal}
     *
     * @param number 数字
     * @return {@link BigDecimal}
     * @since 4.0.9
     */
    public static BigDecimal toBigDecimal(Number number) {
        if (null == number) {
            return BigDecimal.ZERO;
        }
        return toBigDecimal(number.toString());
    }

    /**
     * 数字转{@link BigDecimal}
     *
     * @param number 数字
     * @return {@link BigDecimal}
     * @since 4.0.9
     */
    public static BigDecimal toBigDecimal(String number) {
        return (null == number) ? BigDecimal.ZERO : new BigDecimal(number);
    }

    /**
     * string转金额
     * @param amount
     * @return
     */
    public static BigDecimal getBigDecimal(String amount) {
        try {
            return new BigDecimal(StringUtils.isEmpty(amount) ? "0" : amount);
        } catch (Exception var2) {
            var2.printStackTrace();
            return BigDecimal.ZERO;
        }
    }
}
