package com.xforceplus.phoenix.tools.util;

import org.apache.commons.lang3.StringUtils;

/**
 * @program: phoenix-purchaser-tools
 * @description 字符串工具类
 * <p>
 * 只存放通用工具包(Guava/Spring/Apache)没有的方法
 * </p>
 * @author: wdye
 * @created: 2020-06-29 13:56
 */
public final class StrUtil {
    private StrUtil() {
    }

    /**
     * 截取最后length条
     *
     * @param str
     * @param length
     * @return
     */
    public static String subLast(String str, int length) {
        int strLength = StringUtils.length(str);
        if (strLength == 0) {
            return null;
        }
        return StringUtils.substring(str, strLength > length ? strLength - length : 0);
    }
}
