/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.tools.event;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.xforceplus.phoenix.tools.event.AbstractCustomEventHandler;
import com.xforceplus.phoenix.tools.event.AsyncCustomEvent;
import com.xforceplus.phoenix.tools.event.BaseCustomEvent;
import com.xforceplus.phoenix.tools.util.SpringContextUtil;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBusPublisher {
    private static final Logger log = LoggerFactory.getLogger(EventBusPublisher.class);

    private EventBusPublisher() {
    }

    private static EventBus getInstance(Executor executor) {
        if (null == executor) {
            return EventBusHolder.instance;
        }
        if (EventBusHolder.asyncInstance == null) {
            EventBusHolder.asyncInstance = new AsyncEventBus(executor);
        }
        return EventBusHolder.asyncInstance;
    }

    public static void publish(BaseCustomEvent event) {
        if (event == null) {
            return;
        }
        AsyncCustomEvent asyncEvent = event.getClass().getAnnotation(AsyncCustomEvent.class);
        Executor executor = null;
        if (null != asyncEvent) {
            executor = SpringContextUtil.getBean(asyncEvent.beanName(), Executor.class);
        }
        EventBusPublisher.getInstance(executor).post((Object)event);
    }

    protected static void register(AbstractCustomEventHandler<? extends BaseCustomEvent> handler, Executor executor) {
        if (handler == null) {
            return;
        }
        EventBusPublisher.getInstance(executor).register(handler);
        log.debug("EventBusPublisher register: {} success", handler);
    }

    protected static void unregister(AbstractCustomEventHandler<? extends BaseCustomEvent> handler, Executor executor) {
        if (handler == null) {
            return;
        }
        EventBusPublisher.getInstance(executor).unregister(handler);
        log.debug("EventBusPublisher unregister: {} success", handler);
    }

    private static class EventBusHolder {
        private static final EventBus instance = new EventBus();
        private static AsyncEventBus asyncInstance = null;

        private EventBusHolder() {
        }
    }
}

