/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.tools.logger;

import com.xforceplus.phoenix.tools.logger.AbstractBaseLogger;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class SimpleErrorLogger
extends AbstractBaseLogger {
    private String errorCode;
    private String exceptionName;
    private String exceptionStackTrace;
    private String errorMessage;

    private SimpleErrorLogger(Exception e) {
        this.errorMessage = e.getMessage();
        this.exceptionName = e.getClass().getSimpleName();
        this.exceptionStackTrace = ExceptionUtils.getStackTrace((Throwable)e);
    }

    public static SimpleErrorLogger of(Exception exception) {
        return new SimpleErrorLogger(exception);
    }

    public SimpleErrorLogger errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("errorCode=").append(this.errorCode).append(",");
        stringBuilder.append("exceptionName=").append(this.exceptionName).append(",");
        stringBuilder.append("errorMessage=").append(this.errorMessage).append(",");
        stringBuilder.append("exceptionStackTrace=").append(this.exceptionStackTrace);
        return stringBuilder.toString();
    }
}

