/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.tools.transaction;

import com.xforceplus.phoenix.tools.constant.RedissonConstants;
import com.xforceplus.phoenix.tools.exception.LockException;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;

public class BaseLockService {
    protected void fastTryLock(RLock lock, long lockLeaseTimeMillSecond) {
        this.tryLock(lock, 0L, lockLeaseTimeMillSecond);
    }

    protected void tryLock(RLock lock, long lockLeaseTimeMillSecond) {
        this.tryLock(lock, RedissonConstants.LOCK_NORMAL_WAIT_TIME_MILLI_SECOND, lockLeaseTimeMillSecond);
    }

    protected void tryLock(RLock lock, long lockWaitTimeMillSecond, long lockLeaseTimeMillSecond) {
        try {
            boolean lockFlag = lock.tryLock(lockWaitTimeMillSecond, lockLeaseTimeMillSecond, TimeUnit.MILLISECONDS);
            if (!lockFlag) {
                throw new LockException(String.format("\u9501: %s \u5c1d\u8bd5\u83b7\u53d6\u5931\u8d25", lock.toString()));
            }
        }
        catch (InterruptedException e) {
            throw new LockException(e.getMessage());
        }
    }

    protected void unLock(boolean releaseLock, RLock lock) {
        if (releaseLock) {
            lock.unlock();
        }
    }
}

