/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.tools.transaction.event;

import com.xforceplus.phoenix.tools.transaction.event.AfterTxCommitCallAsyncNewTxEvent;
import com.xforceplus.phoenix.tools.transaction.event.AfterTxCommitCallEvent;
import com.xforceplus.phoenix.tools.transaction.event.AfterTxCommitCallNewTxEvent;
import com.xforceplus.phoenix.tools.transaction.event.AfterTxCompleteCallAsyncEvent;
import com.xforceplus.phoenix.tools.transaction.event.AfterTxCompleteCallEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class AfterCommitCallEventListener {
    private static final Logger log = LoggerFactory.getLogger(AfterCommitCallEventListener.class);

    @TransactionalEventListener
    @Transactional(rollbackFor={RuntimeException.class})
    public void handlerForAfterCommit(AfterTxCommitCallEvent event) {
        event.call();
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMPLETION)
    @Transactional(rollbackFor={RuntimeException.class})
    public void handlerForAfterComplete(AfterTxCompleteCallEvent event) {
        event.call();
    }

    @Async
    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMPLETION)
    @Transactional(rollbackFor={RuntimeException.class})
    public void handlerForAfterComplete(AfterTxCompleteCallAsyncEvent event) {
        event.call();
    }

    @TransactionalEventListener
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={RuntimeException.class})
    public void handlerForNewTx(AfterTxCommitCallNewTxEvent event) {
        event.call();
    }

    @Async
    @TransactionalEventListener
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={RuntimeException.class})
    public void handlerForNewTx(AfterTxCommitCallAsyncNewTxEvent event) {
        event.call();
    }
}

