/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.tools.transaction.impl;

import com.xforceplus.phoenix.tools.constant.RedissonConstants;
import com.xforceplus.phoenix.tools.exception.LockException;
import com.xforceplus.phoenix.tools.transaction.BaseLockService;
import com.xforceplus.phoenix.tools.transaction.TransactionLockServiceInvoker;
import com.xforceplus.phoenix.tools.transaction.TransactionServiceInvoker;
import com.xforceplus.phoenix.tools.transaction.consumer.Function3;
import com.xforceplus.phoenix.tools.util.AppIdDefiner;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultTransactionLockServiceInvokerImpl
extends BaseLockService
implements TransactionLockServiceInvoker {
    private static final Logger log = LoggerFactory.getLogger(DefaultTransactionLockServiceInvokerImpl.class);
    @Autowired
    private TransactionServiceInvoker transactionServiceInvoker;
    @Autowired(required=false)
    private RedissonClient redissonClient;

    @Override
    public void callWithLock(String lockKey, Runnable runnable) {
        String key = AppIdDefiner.getSimpleId() + lockKey;
        boolean releaseLock = true;
        RLock lock = this.redissonClient.getLock(key);
        try {
            this.fastTryLock(lock, RedissonConstants.LOCK_LEASE_TIME_MILLI_SECOND);
            runnable.run();
        }
        catch (LockException e) {
            releaseLock = false;
            throw e;
        }
        finally {
            this.unLock(releaseLock, lock);
        }
    }

    @Override
    public void callNewTxWithLock(RLock lock, Runnable runnable) {
        this.callNewTxWithLock(lock, RedissonConstants.LOCK_LEASE_TIME_MILLI_SECOND, runnable);
    }

    @Override
    public void callNewTxWithLock(RLock lock, long lockLeaseTimeMillisecond, Runnable runnable) {
        boolean releaseLock = true;
        try {
            this.tryLock(lock, lockLeaseTimeMillisecond);
            this.transactionServiceInvoker.callNewTx(runnable, (Long)lockLeaseTimeMillisecond);
        }
        catch (LockException e) {
            releaseLock = false;
            throw e;
        }
        finally {
            this.unLock(releaseLock, lock);
        }
    }

    @Override
    public <A1> void callNewTxWithLock(RLock lock, Consumer<A1> consumer, A1 arg1) {
        boolean releaseLock = true;
        try {
            this.tryLock(lock, RedissonConstants.LOCK_LEASE_TIME_MILLI_SECOND);
            this.transactionServiceInvoker.callNewTx(consumer, arg1, RedissonConstants.LOCK_LEASE_TIME_MILLI_SECOND);
        }
        catch (LockException e) {
            releaseLock = false;
            throw e;
        }
        finally {
            this.unLock(releaseLock, lock);
        }
    }

    @Override
    public <R> R callNewTxWithLock(RLock lock, Supplier<R> supplier) {
        boolean releaseLock = true;
        try {
            this.tryLock(lock, RedissonConstants.LOCK_LEASE_TIME_MILLI_SECOND);
            R r = this.transactionServiceInvoker.callNewTx(supplier, RedissonConstants.LOCK_LEASE_TIME_MILLI_SECOND);
            return r;
        }
        catch (LockException e) {
            releaseLock = false;
            throw e;
        }
        finally {
            this.unLock(releaseLock, lock);
        }
    }

    @Override
    public <A1, R> R callNewTxWithLock(RLock lock, Function<A1, R> function, A1 arg1) {
        boolean releaseLock = true;
        try {
            this.tryLock(lock, RedissonConstants.LOCK_LEASE_TIME_MILLI_SECOND);
            R r = this.transactionServiceInvoker.callNewTx(function, arg1, RedissonConstants.LOCK_LEASE_TIME_MILLI_SECOND);
            return r;
        }
        catch (LockException e) {
            releaseLock = false;
            throw e;
        }
        finally {
            this.unLock(releaseLock, lock);
        }
    }

    @Override
    public <A1, R> R callNewTxWithLock(RLock lock, long lockLeaseTimeMillISecond, Function<A1, R> function, A1 arg1) {
        boolean releaseLock = true;
        try {
            this.tryLock(lock, lockLeaseTimeMillISecond);
            R r = this.transactionServiceInvoker.callNewTx(function, arg1, (Long)lockLeaseTimeMillISecond);
            return r;
        }
        catch (LockException e) {
            releaseLock = false;
            throw e;
        }
        finally {
            this.unLock(releaseLock, lock);
        }
    }

    @Override
    public <A1, A2, R> R callNewTxWithLock(RLock lock, BiFunction<A1, A2, R> biFunction, A1 arg1, A2 arg2) {
        boolean releaseLock = true;
        try {
            this.tryLock(lock, RedissonConstants.LOCK_LEASE_TIME_MILLI_SECOND);
            R r = this.transactionServiceInvoker.callNewTx(biFunction, arg1, arg2, RedissonConstants.LOCK_LEASE_TIME_MILLI_SECOND);
            return r;
        }
        catch (LockException e) {
            releaseLock = false;
            throw e;
        }
        finally {
            this.unLock(releaseLock, lock);
        }
    }

    @Override
    public <A1, A2, A3, R> R callNewTxWithLock(RLock lock, long lockLeaseTimeMillSecond, Function3<A1, A2, A3, R> function3, A1 arg1, A2 arg2, A3 arg3) {
        boolean releaseLock = true;
        try {
            this.tryLock(lock, lockLeaseTimeMillSecond);
            R r = this.transactionServiceInvoker.callNewTx(function3, arg1, arg2, arg3, lockLeaseTimeMillSecond);
            return r;
        }
        catch (LockException e) {
            releaseLock = false;
            throw e;
        }
        finally {
            this.unLock(releaseLock, lock);
        }
    }
}

