/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.tools.transaction.impl;

import com.xforceplus.phoenix.tools.exception.LockException;
import com.xforceplus.phoenix.tools.transaction.TransactionServiceInvoker;
import com.xforceplus.phoenix.tools.transaction.consumer.Consumer2;
import com.xforceplus.phoenix.tools.transaction.consumer.Function3;
import com.xforceplus.phoenix.tools.transaction.consumer.Function4;
import com.xforceplus.phoenix.tools.transaction.consumer.Function5;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class DefaultTransactionServiceInvokerImpl
implements TransactionServiceInvoker {
    private static final Logger log = LoggerFactory.getLogger(DefaultTransactionServiceInvokerImpl.class);

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={RuntimeException.class})
    public void callNewTx(Runnable runnable) {
        runnable.run();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={RuntimeException.class})
    public void callNewTx(Runnable runnable, Long lockLeaseTime) {
        long lockExpired = System.currentTimeMillis() + lockLeaseTime;
        runnable.run();
        this.rollbackWhenLockTimeout(lockExpired, lockLeaseTime);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={RuntimeException.class})
    public <A1> void callNewTx(Consumer<A1> consumer, A1 arg1) {
        consumer.accept(arg1);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={RuntimeException.class})
    public <A1> void callNewTx(Consumer<A1> consumer, A1 arg1, Long lockLeaseTime) {
        long lockExpired = System.currentTimeMillis() + lockLeaseTime;
        consumer.accept(arg1);
        this.rollbackWhenLockTimeout(lockExpired, lockLeaseTime);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={RuntimeException.class})
    public <R> R callNewTx(Supplier<R> supplier) {
        R r = supplier.get();
        return r;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={RuntimeException.class})
    public <R> R callNewTx(Supplier<R> supplier, Long lockLeaseTime) {
        long lockExpired = System.currentTimeMillis() + lockLeaseTime;
        R r = supplier.get();
        this.rollbackWhenLockTimeout(lockExpired, lockLeaseTime);
        return r;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={RuntimeException.class})
    public <A1, R> R callNewTx(Function<A1, R> function, A1 arg1) {
        R r = function.apply(arg1);
        return r;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={RuntimeException.class})
    public <A1, R> R callNewTx(Function<A1, R> function, A1 arg1, Long lockLeaseTime) {
        long lockExpired = System.currentTimeMillis() + lockLeaseTime;
        R r = function.apply(arg1);
        this.rollbackWhenLockTimeout(lockExpired, lockLeaseTime);
        return r;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={RuntimeException.class})
    public <A1, A2, R> R callNewTx(BiFunction<A1, A2, R> biFunction, A1 arg1, A2 arg2) {
        R r = biFunction.apply(arg1, arg2);
        return r;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={RuntimeException.class})
    public <A1, A2, A3, R> R callNewTx(Function3<A1, A2, A3, R> function3, A1 arg1, A2 arg2, A3 arg3) {
        R r = function3.apply(arg1, arg2, arg3);
        return r;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={RuntimeException.class})
    public <A1, A2, A3, A4, R> R callNewTx(Function4<A1, A2, A3, A4, R> function4, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        R r = function4.apply(arg1, arg2, arg3, arg4);
        return r;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={RuntimeException.class})
    public <A1, A2, A3, A4, A5, R> R callNewTx(Function5<A1, A2, A3, A4, A5, R> function5, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        R r = function5.apply(arg1, arg2, arg3, arg4, arg5);
        return r;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={RuntimeException.class})
    public <A1, A2, R> R callNewTx(BiFunction<A1, A2, R> biFunction, A1 arg1, A2 arg2, Long lockLeaseTime) {
        long lockExpired = System.currentTimeMillis() + lockLeaseTime;
        R r = biFunction.apply(arg1, arg2);
        this.rollbackWhenLockTimeout(lockExpired, lockLeaseTime);
        return r;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={RuntimeException.class})
    public <A1, A2, A3, R> R callNewTx(Function3<A1, A2, A3, R> function3, A1 arg1, A2 arg2, A3 arg3, Long lockLeaseTime) {
        long lockExpired = System.currentTimeMillis() + lockLeaseTime;
        R r = function3.apply(arg1, arg2, arg3);
        this.rollbackWhenLockTimeout(lockExpired, lockLeaseTime);
        return r;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={RuntimeException.class})
    public <A1, A2> void callNewTx(Consumer2<A1, A2> consumer2, A1 var1, A2 var2) {
        consumer2.accept(var1, var2);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={RuntimeException.class})
    public <A1, A2> void callNewTx(Consumer2<A1, A2> consumer2, A1 var1, A2 var2, Long lockLeaseTime) {
        long lockExpired = System.currentTimeMillis() + lockLeaseTime;
        consumer2.accept(var1, var2);
        this.rollbackWhenLockTimeout(lockExpired, lockLeaseTime);
    }

    @Override
    @Async
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={RuntimeException.class})
    public void callNewAsyncTx(Runnable runnable) {
        runnable.run();
    }

    @Override
    @Async
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={RuntimeException.class})
    public void callNewAsyncTx(Runnable runnable, Long lockLeaseTime) {
        long lockExpired = System.currentTimeMillis() + lockLeaseTime;
        runnable.run();
        this.rollbackWhenLockTimeout(lockExpired, lockLeaseTime);
    }

    private void rollbackWhenLockTimeout(long lockExpired, long lockLeaseTime) {
        if (System.currentTimeMillis() - lockLeaseTime > lockExpired) {
            String err = String.format("\u9501: \u8d85\u65f6! \u4e8b\u52a1\u56de\u6eda", new Object[0]);
            throw new LockException(err);
        }
    }
}

