/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.tools.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class DateUtil {
    public static final String DATE_YEAR_MONTH = "yyyyMM";

    public static String getCurDateTime(String format) {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
        String dataTime = now.format(dateTimeFormatter);
        return dataTime;
    }

    public static String nextMonth(String month) {
        String result = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_YEAR_MONTH);
            Date date = sdf.parse(month);
            Instant instant = date.toInstant();
            ZoneId zone = ZoneId.systemDefault();
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
            LocalDate localDate = localDateTime.toLocalDate();
            result = localDate.plusMonths(1L).format(DateTimeFormatter.ofPattern(DATE_YEAR_MONTH));
        }
        catch (ParseException var2) {
            var2.printStackTrace();
        }
        return result;
    }

    public static String lastMonth(String month) {
        String result = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_YEAR_MONTH);
            Date date = sdf.parse(month);
            Instant instant = date.toInstant();
            ZoneId zone = ZoneId.systemDefault();
            LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
            LocalDate localDate = localDateTime.toLocalDate();
            result = localDate.minusMonths(1L).format(DateTimeFormatter.ofPattern(DATE_YEAR_MONTH));
        }
        catch (ParseException var2) {
            var2.printStackTrace();
        }
        return result;
    }
}

