package com.xforceplus.phoenix.tools.enums;

import com.xforceplus.phoenix.tools.enums.base.IEnumIntValue;

/**
 * @program: phoenix-purchaser-tools
 * @description: 发票是否满足勾选条件枚举
 * @author: cuixiangyu
 * @created: 2020-05-06 15:52
 */
public enum AuthSatisfyStatusEnum implements IEnumIntValue {

    /**
     * 未满足勾选条件-正常
     */
    UNSATISFY(0,"未满足勾选条件-正常"),
    /**
     * 满足勾选条件-正常
     */
    SATISFY(1,"满足勾选条件-正常"),
    /**
     * 未满足勾选条件-预警
     */
    UNSATISFY_WARN(10, "未满足勾选条件-预警"),
    /**
     * 满足勾选条件-预警
     */
    SATISFY_WARN(11, "满足勾选条件-预警"),
    ;

    private final Integer value;
    private final String description;

    AuthSatisfyStatusEnum(Integer value, String description) {
        this.value = value;
        this.description = description;
    }

    @Override
    public Integer value() {
        return this.value;
    }

    public String getDescription() {
        return description;
    }

}
