package com.xforceplus.phoenix.tools.enums;

import com.xforceplus.phoenix.tools.enums.base.IEnumStringValue;

/**
 * @author liuda
 * @version 1.0
 * @date 2020/8/21 14:33
 * 数据来源枚举类
 */
public enum DataSourceEnum implements IEnumStringValue {
    TAX_AUTH("1","税件底账"),
    TAX_CHECK("2","税件验真"),
    SELLER_ISSUE("3","销方开具"),
    INTERIOR_RECOG("4","内部识别"),
    EXTERNAL_RECOG("5","外部识别")
    ;

    private final String code;
    private final String description;

    DataSourceEnum(String code, String description) {
        this.code = code;
        this.description = description;
    }

    @Override
    public String value() {
        return this.code;
    }

    public String getDescription() {
        return description;
    }

}
