package com.xforceplus.phoenix.tools.enums;

import com.xforceplus.phoenix.tools.enums.base.IEnumIntValue;

/**
 * @program: phoenix-purchaser-tools
 * @description 发票特殊标记枚举
 * @author: 刘达
 * @created: 2020-04-27 14:11
 */
public enum InvoiceSpecialFlagEnum implements IEnumIntValue {
    /**
     * 默认
     */
    DEFAULT(0, "默认"),
    /**
     * 通行费
     */
    TOLL(1, "通行费"),
    /**
     * 成品油
     */
    OIL(2, "成品油"),
    /**
     * 区块链
     */
    BLOCK_CHAIN(3,"区块链");

    private final Integer code;
    private final String msg;

    InvoiceSpecialFlagEnum(Integer code, String msg){
        this.code = code;
        this.msg = msg;
    }

    public Integer code(){
        return code;
    }

    public String msg(){
        return msg;
    }

    @Override
    public Integer value() {
        return code;
    }
}
