package com.xforceplus.phoenix.tools.enums;

import com.xforceplus.phoenix.tools.enums.base.IEnumIntValue;

/**
 * @program: phoenix-purchaser-tools
 * @description: 配单状态枚举
 * @author: cuixiangyu
 * @created: 2020-05-07 10:07
 */
public enum MatchStatusEnum implements IEnumIntValue {
    /**
     * 未匹配
     */
    NOT_MATCH(0,"未匹配"),
    /**
     * 匹配中
     */
    IN_MATCH(1,"匹配中"),
    /**
     * 已匹配
     */
    COMPLETE_MATCH(2,"已匹配"),
    /**
     * 待确认
     */
    NEED_CONFIRM(4,"待确认")
    ;

    private final Integer value;
    private final String description;

    MatchStatusEnum(Integer value, String description) {
        this.value = value;
        this.description = description;
    }

    @Override
    public Integer value() {
        return this.value;
    }

    public String getDescription() {
        return description;
    }
}
