package com.xforceplus.phoenix.tools.enums;

import com.xforceplus.phoenix.tools.enums.base.IEnumIntValue;

/**
 * @program: phoenix-purchaser-tools
 * @description: 签收状态枚举
 * @author: 刘达
 */
public enum ReceiptStatusEnum implements IEnumIntValue {
    /**
     * 默认
     */
    RECEIPT_DEFAULT(0,  "未寄送"),
    /**
     *未签收
     */
    RECEIPT_NOT(1,  "未签收"),
    /**
     * 已签收
     */
    RECEIPT_ALREADY(2,  "已签收");

    private final Integer value;
    private final String description;

    ReceiptStatusEnum(Integer value, String description) {
        this.value = value;
        this.description = description;
    }

    @Override
    public Integer value() {
        return this.value;
    }

    public String getDescription() {
        return description;
    }
}
