package com.xforceplus.phoenix.tools.enums;

import com.xforceplus.phoenix.tools.enums.base.IEnumIntValue;

/**
 * @program: phoenix-purchaser-tools
 * @description: 签收状态枚举
 * @author: cuixiangyu
 * @created: 2020-05-07 09:59
 */
public enum SignForStatusEnum implements IEnumIntValue {
    /**
     * 默认
     */
    DEFAULT(0,"默认"),
    /**
     * 未签收
     */
    NOT_SIGN(1,"未签收"),
    /**
     * 已签收
     */
    SIGN_FOR(2,"已签收"),
    ;

    private final Integer value;
    private final String description;

    SignForStatusEnum(Integer value, String description) {
        this.value = value;
        this.description = description;
    }

    @Override
    public Integer value() {
        return this.value;
    }

    public String getDescription() {
        return description;
    }
}
