package com.xforceplus.phoenix.tools.enums.base;

/**
 * 枚举字符串类型基类
 *
 * @author: wdye
 * @created: 2019-09-18 10:23
 */
public interface IEnumStringValue extends IEnumValue<String> {
    /**
     * 忽略大小写值比较(是否相等)
     *
     * @param anotherValue
     * @return
     */
    default boolean isValueEqualIgnoreCase(String anotherValue) {
        return value().equalsIgnoreCase(anotherValue);
    }

    /**
     * 忽略大小写值比较(是否不相等)
     *
     * @param anotherValue
     * @return
     */
    default boolean isValueNotEqualIgnoreCase(String anotherValue) {
        return !isValueEqualIgnoreCase(anotherValue);
    }
}
