package com.xforceplus.phoenix.tools.event;

import com.google.common.eventbus.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.ReflectionUtils;

/**
 * @program: phoenix-purchaser-tools
 * @description 自定义事件订阅基础类
 * @author: wdye
 * @created: 2020-03-27 12:53
 */
@Slf4j
public abstract class AbstractCustomEventHandler<CustomEvent extends BaseCustomEvent> {

    private static final String methodName = "onSubScribe";

    @Subscribe
    public void onEvent(BaseCustomEvent event) {
        if (ReflectionUtils.findMethod(this.getClass(), methodName, event.getClass()) != null) {
            try {
                if (!onSubScribe((CustomEvent) event)) {
                    log.warn("custom event handle event {} fail", event.getClass());
                }
            } catch (Exception e) {
                log.error("custom event handle event {} {}", event.getClass(), e);
            }
        }
    }

    /**
     * 订阅消息
     *
     * @param event
     * @return
     */
    public abstract boolean onSubScribe(CustomEvent event);
}