package com.xforceplus.phoenix.tools.event;

import com.xforceplus.phoenix.tools.enable.AutoConfiguration;
import com.xforceplus.phoenix.tools.util.SpringContextUtil;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.Executor;

/**
 * @program: phoenix-purchaser-tools
 * @description 自定义事件自动注册配置类
 * @author: wdye
 * @created: 2020-03-27 11:30
 */
public class EventAutoConfiguration implements InitializingBean, DisposableBean, AutoConfiguration {

    private Map<String, AbstractCustomEventHandler> beans = null;

    @Override
    public void afterPropertiesSet() throws Exception {
        beans = SpringContextUtil.getBeansOfType(AbstractCustomEventHandler.class);
        if (beans != null) {
            for (AbstractCustomEventHandler eventAbstract : beans.values()) {
                EventBusPublisher.register(eventAbstract, getExecutor(eventAbstract));
            }
        }
    }

    @Override
    public void destroy() throws Exception {
        if (beans != null) {
            for (AbstractCustomEventHandler eventAbstract : beans.values()) {
                EventBusPublisher.unregister(eventAbstract, getExecutor(eventAbstract));
            }
        }
    }

    private Executor getExecutor(AbstractCustomEventHandler eventAbstract) {
        Type genericSuperclass = eventAbstract.getClass().getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType) {
            Type event = ((ParameterizedType) genericSuperclass).getActualTypeArguments()[0];
            AsyncCustomEvent asyncEvent = (AsyncCustomEvent) ((Class) event).getAnnotation(AsyncCustomEvent.class);
            if (null != asyncEvent) {
                return SpringContextUtil.getBean(asyncEvent.beanName(), Executor.class);
            }
        }
        return null;
    }
}