package com.xforceplus.phoenix.tools.logger;

import com.xforceplus.phoenix.tools.enums.BusinessTypeEnum;
import org.apache.commons.lang3.StringUtils;

/**
 * @program: phoenix-purchaser-tools
 * @description
 * @author: wdye
 * @created: 2020-02-03 12:32
 */
public class SimpleBusinessLogger extends AbstractBaseLogger {

    /**
     * 业务类型
     */
    private BusinessTypeEnum businessTypeEnum;

    private Long userId;

    private String invoiceCode;

    private String invoiceNo;

    private Integer status;

    private Object ext;

    private SimpleBusinessLogger(BusinessTypeEnum businessTypeEnum) {
        this.businessTypeEnum = businessTypeEnum;
    }

    public static SimpleBusinessLogger of(BusinessTypeEnum businessTypeEnum) {
        return new SimpleBusinessLogger(businessTypeEnum);
    }

    public SimpleBusinessLogger userId(Long userId) {
        this.userId = userId;
        return this;
    }

    public SimpleBusinessLogger invoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
        return this;
    }

    public SimpleBusinessLogger invoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
        return this;
    }

    public SimpleBusinessLogger status(Integer status) {
        this.status = status;
        return this;
    }

    public SimpleBusinessLogger ext(Object ext) {
        this.ext = ext;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("businessType=").append(businessTypeEnum.value()).append(COMMA);
        stringBuilder.append("userId=").append(userId).append(COMMA);
        stringBuilder.append("invoiceCode=").append(invoiceCode).append(COMMA);
        stringBuilder.append("invoiceNo=").append(invoiceNo).append(COMMA);
        stringBuilder.append("status=").append(status).append(COMMA);
        stringBuilder.append("ext=").append(null != ext ? ext.toString() : StringUtils.EMPTY);
        return stringBuilder.toString();
    }
}

