package com.xforceplus.phoenix.tools.logger;

import org.apache.commons.lang3.exception.ExceptionUtils;

/**
 * @program: phoenix-purchaser-tools
 * @description
 * @author: wdye
 * @created: 2020-02-03 12:32
 */
public class SimpleErrorLogger extends AbstractBaseLogger {

    /**
     * 错误代码
     */
    private String errorCode;

    /**
     * 异常名称
     */
    private String exceptionName;

    /**
     * 异常堆栈信息
     */
    private String exceptionStackTrace;

    /**
     * 异常信息
     */
    private String errorMessage;

    private SimpleErrorLogger(Exception e) {
        this.errorMessage = e.getMessage();
        this.exceptionName = e.getClass().getSimpleName();
        this.exceptionStackTrace = ExceptionUtils.getStackTrace(e);
    }

    public static SimpleErrorLogger of(Exception exception) {
        return new SimpleErrorLogger(exception);
    }

    public SimpleErrorLogger errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("errorCode=").append(errorCode).append(COMMA);
        stringBuilder.append("exceptionName=").append(exceptionName).append(COMMA);
        stringBuilder.append("errorMessage=").append(errorMessage).append(COMMA);
        stringBuilder.append("exceptionStackTrace=").append(exceptionStackTrace);
        return stringBuilder.toString();
    }
}

