package com.xforceplus.phoenix.tools.transaction;

import com.xforceplus.phoenix.tools.transaction.consumer.Consumer2;
import com.xforceplus.phoenix.tools.transaction.consumer.Function3;
import com.xforceplus.phoenix.tools.transaction.consumer.Function4;
import com.xforceplus.phoenix.tools.transaction.consumer.Function5;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

/**
 * @program: phoenix-purchaser-tools
 * @description 事务调度者
 * @author: wdye
 * @created: 2019-10-28 17:50
 */
public interface TransactionServiceInvoker {

    /**
     * 新起事务
     *
     * @param runnable
     */
    void callNewTx(Runnable runnable);

    /**
     * 新起事务
     *
     * @param runnable
     * @param lockLeaseTime 锁释放时间(单位毫秒 如: 5秒内事务未执行完则事务回滚,就传入5000)
     */
    void callNewTx(Runnable runnable, Long lockLeaseTime);

    /**
     * 新起事务
     * 提供一个A1类型的输入参数，不返回执行结果
     *
     * @param consumer
     * @param arg1
     * @param <A1>
     */
    <A1> void callNewTx(Consumer<A1> consumer, A1 arg1);

    /**
     * 新起事务
     * 提供一个A1类型的输入参数，不返回执行结果
     *
     * @param consumer
     * @param arg1
     * @param lockLeaseTime 锁释放时间(单位毫秒 如: 5秒内事务未执行完则事务回滚,就传入5000)
     * @param <A1>
     */
    <A1> void callNewTx(Consumer<A1> consumer, A1 arg1, Long lockLeaseTime);

    /**
     * 新起事务
     * 不传入参数，返回一个值
     *
     * @param supplier
     * @param <R>
     * @return
     */
    <R> R callNewTx(Supplier<R> supplier);

    /**
     * 新起事务
     * 不传入参数，返回一个值
     *
     * @param supplier
     * @param lockLeaseTime 锁释放时间(单位毫秒 如: 5秒内事务未执行完则事务回滚,就传入5000)
     * @param <R>
     * @return
     */
    <R> R callNewTx(Supplier<R> supplier, Long lockLeaseTime);

    /**
     * 新起事务
     * 接收一个参数并返回结果的函数
     *
     * @param function
     * @param arg1
     * @param <A1>
     * @param <R>
     * @return
     */
    <A1, R> R callNewTx(Function<A1, R> function, A1 arg1);

    /**
     * 新起事务
     * 接收一个参数并返回结果的函数
     *
     * @param function
     * @param arg1
     * @param lockLeaseTime 锁释放时间(单位毫秒 如: 5秒内事务未执行完则事务回滚,就传入5000)
     * @param <A1>
     * @param <R>
     * @return
     */
    <A1, R> R callNewTx(Function<A1, R> function, A1 arg1, Long lockLeaseTime);

    /**
     * 新起事务
     * 提供一个A1,A2类型的输入参数，并返回结果的函数
     *
     * @param biFunction
     * @param arg1
     * @param arg2
     * @param <A1>
     * @param <A2>
     * @param <R>
     * @return
     */
    <A1, A2, R> R callNewTx(BiFunction<A1, A2, R> biFunction, A1 arg1, A2 arg2);

    /**
     * 新起事务
     * 提供一个A1,A2,A3类型的输入参数，并返回结果的函数
     *
     * @param function3
     * @param arg1
     * @param arg2
     * @param arg3
     * @param <A1>
     * @param <A2>
     * @param <A3>
     * @param <R>
     * @return
     */
    <A1, A2, A3, R> R callNewTx(Function3<A1, A2, A3, R> function3, A1 arg1, A2 arg2, A3 arg3);

    /**
     * 新起事务
     * 提供一个A1,A2,A3,A4类型的输入参数，并返回结果的函数
     *
     * @param function4
     * @param arg1
     * @param arg2
     * @param arg3
     * @param arg4
     * @param <A1>
     * @param <A2>
     * @param <A3>
     * @param <A4>
     * @param <R>
     * @return
     */
    <A1, A2, A3, A4, R> R callNewTx(Function4<A1, A2, A3, A4, R> function4, A1 arg1, A2 arg2, A3 arg3, A4 arg4);

    /**
     * 新起事务
     * 提供一个A1,A2,A3,A4,A5类型的输入参数，并返回结果的函数
     *
     * @param function5
     * @param arg1
     * @param arg2
     * @param arg3
     * @param arg4
     * @param arg5
     * @param <A1>
     * @param <A2>
     * @param <A3>
     * @param <A4>
     * @param <A5>
     * @param <R>
     * @return
     */
    <A1, A2, A3, A4, A5, R> R callNewTx(Function5<A1, A2, A3, A4, A5, R> function5, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5);

    /**
     * 新起事务
     * 提供一个A1,A2类型的输入参数，并返回结果的函数
     *
     * @param biFunction
     * @param arg1
     * @param arg2
     * @param lockLeaseTime 锁释放时间(单位毫秒 如: 5秒内事务未执行完则事务回滚,就传入5000)
     * @param <A1>
     * @param <A2>
     * @param <R>
     * @return
     */
    <A1, A2, R> R callNewTx(BiFunction<A1, A2, R> biFunction, A1 arg1, A2 arg2, Long lockLeaseTime);

    /**
     * 新起事务
     * 提供一个A1,A2,A3类型的输入参数，并返回结果的函数
     *
     * @param function3
     * @param arg1
     * @param arg2
     * @param arg3
     * @param lockLeaseTime 锁释放时间(单位毫秒 如: 5秒内事务未执行完则事务回滚,就传入5000)
     * @param <A1>
     * @param <A2>
     * @param <A3>
     * @param <R>
     * @return
     */
    <A1, A2, A3, R> R callNewTx(Function3<A1, A2, A3, R> function3, A1 arg1, A2 arg2, A3 arg3, Long lockLeaseTime);

    /**
     * 新起事务
     * 提供一个A1,A2类型的输入参数，不返回执行结果
     *
     * @param consumer2
     * @param var1
     * @param var2
     * @param <A1>
     * @param <A2>
     */
    <A1, A2> void callNewTx(Consumer2<A1, A2> consumer2, A1 var1, A2 var2);

    /**
     * 新起事务
     * 提供一个A1,A2类型的输入参数，不返回执行结果
     *
     * @param consumer2
     * @param var1
     * @param var2
     * @param lockLeaseTime 锁释放时间(单位毫秒 如: 5秒内事务未执行完则事务回滚,就传入5000)
     * @param <A1>
     * @param <A2>
     */
    <A1, A2> void callNewTx(Consumer2<A1, A2> consumer2, A1 var1, A2 var2, Long lockLeaseTime);

    /**
     * 新起异步事务
     *
     * @param runnable
     */
    void callNewAsyncTx(Runnable runnable);

    /**
     * 新起异步事务
     *
     * @param runnable
     * @param lockLeaseTime 锁释放时间(单位毫秒 如: 5秒内事务未执行完则事务回滚,就传入5000)
     */
    void callNewAsyncTx(Runnable runnable, Long lockLeaseTime);
}
