package com.xforceplus.phoenix.tools.transaction.event;

import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

/**
 * @program: phoenix-purchaser-tools
 * @description 事务完成后事件处理
 * @author: wdye
 * @created: 2019-11-01 10:58
 */
@Slf4j
@Component
public class AfterCommitCallEventListener {

    @TransactionalEventListener
    @Transactional(rollbackFor = RuntimeException.class)
    public void handlerForAfterCommit(AfterTxCommitCallEvent event) {
        event.call();
    }

    @TransactionalEventListener(
            phase = TransactionPhase.AFTER_COMPLETION
    )
    @Transactional(rollbackFor = RuntimeException.class)
    public void handlerForAfterComplete(AfterTxCompleteCallEvent event) {
        event.call();
    }

    @Async
    @TransactionalEventListener(
            phase = TransactionPhase.AFTER_COMPLETION
    )
    @Transactional(rollbackFor = RuntimeException.class)
    public void handlerForAfterComplete(AfterTxCompleteCallAsyncEvent event) {
        event.call();
    }

    @TransactionalEventListener
    @Transactional(
            propagation = Propagation.REQUIRES_NEW,
            rollbackFor = RuntimeException.class
    )
    public void handlerForNewTx(AfterTxCommitCallNewTxEvent event) {
        event.call();
    }

    @Async
    @TransactionalEventListener
    @Transactional(
            propagation = Propagation.REQUIRES_NEW,
            rollbackFor = RuntimeException.class
    )
    public void handlerForNewTx(AfterTxCommitCallAsyncNewTxEvent event) {
        event.call();
    }
}
