package com.xforceplus.phoenix.tools.util;

import org.apache.commons.lang3.StringUtils;

/**
 * @author weaponry MrYe
 * @program phoenix-purchaser-tools
 * @description
 * @created 2020-10-30 17:58
 */
public class AppIdDefiner {
    private static final String PROPERTIES_PATH = "/META-INF/app.properties";
    private static String appId = "app.id";
    private static String simpleId = "app.simple.id";

    static {
        appId = PropertiesUtil.getString(PROPERTIES_PATH, appId);
        simpleId = PropertiesUtil.getString(PROPERTIES_PATH, simpleId);
        if (StringUtils.isBlank(appId)) {
            throw new RuntimeException("must Define app.id in /META-INF/app.properties");
        }
    }

    public static String getAppId() {
        return appId;
    }

    public static String getSimpleId() {
        return simpleId;
    }
}
