package com.xforceplus.phoenix.tools.util;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;

/**
 * @program: phoenix-purchaser-tools
 * @description
 * @author: wdye
 * @created: 2020-04-29 11:20
 */
public final class LambdaUtil {

    private LambdaUtil() {
    }

    /**
     * 根据key去重
     * 案例 List.stream().filter(LambdaUtil.distinctByKey(Entity::getFiled)).collect(Collectors.groupingBy(Entity::getFiled))
     *
     * @param keyExtractor
     * @param <T>
     * @return
     */
    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        Set<Object> keySet = ConcurrentHashMap.newKeySet();
        return t -> keySet.add(keyExtractor.apply(t));
    }

    /**
     * 带index的foreach
     *
     * @param elements
     * @param action
     * @param <T>
     */
    public static <T> void forEach(Iterable<? extends T> elements, BiConsumer<Integer, ? super T> action) {
        Objects.requireNonNull(elements);
        Objects.requireNonNull(action);
        int index = 0;
        for (T element : elements) {
            action.accept(index++, element);
        }
    }
}
