package com.xforceplus.phoenix.tools.util;

import com.google.common.collect.Maps;

import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

/**
 * @author weaponry MrYe
 * @program phoenix-purchaser-tools
 * @description
 * @created 2020-10-30 17:57
 */
public class PropertiesUtil {
    private static final Map<String, Properties> propertiesMap = Maps.newHashMap();

    private PropertiesUtil() {
    }

    public static String getString(String propertiesPath, String key) {
        return getString(propertiesPath, key, "");
    }

    public static String getString(String propertiesPath, String key, String defaultValue) {
        Properties properties = propertiesMap.get(propertiesPath);
        if (properties == null) {
            properties = get(propertiesPath);
        }
        return properties != null ? properties.getProperty(key, defaultValue) : defaultValue;
    }

    private static synchronized Properties get(String propertiesPath) {
        Properties properties = propertiesMap.get(propertiesPath);
        if (properties != null) {
            propertiesMap.put(propertiesPath, properties);
            return properties;
        } else {
            properties = load(propertiesPath);
            if (properties != null) {
                propertiesMap.put(propertiesPath, properties);
                return properties;
            } else {
                return null;
            }
        }
    }

    private static Properties load(String propertiesPath) {
        InputStream in = null;
        Properties prop;
        try {
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertiesPath);
            if (in == null) {
                in = AppIdDefiner.class.getResourceAsStream(propertiesPath);
            }
            if (in != null) {
                prop = new Properties();
                prop.load(in);
                return prop;
            }
            return null;
        } catch (Exception e) {
            return null;
        } finally {
            if (in != null) {
                try {
                    in.close();
                } catch (Exception ignored) {
                }
            }
        }
    }
}
