/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.tools.enums;

import com.xforceplus.phoenix.tools.enums.base.IEnumStringValue;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public enum InvoiceTypeEnum implements IEnumStringValue
{
    SPECIAL_ELECTRONIC("se", "^0\\d{9}13", "\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968"),
    SPECIAL("s", "^\\d{7}(1|5)\\d{2}", "\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968"),
    NORMAL("c", "(^\\d{7}(3|6)\\d{2})|(^0\\d{9}(04|05))", "\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968"),
    ELECTRONIC("ce", "^0\\d{9}11", "\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968"),
    NORMAL_ROLL("ju", "^0\\d{9}(06|07)", "\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968(\u5377\u7968)"),
    TRAFFIC("ct", "^0\\d{9}12", "\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968(\u901a\u884c\u8d39)"),
    VEHICLE("v", "^1\\d{6}2\\d{4}", "\u673a\u52a8\u8f66\u7edf\u4e00\u9500\u552e\u53d1\u7968"),
    BLOCK_CHAIN_INVOICE("ce", "^1\\d{9}10", "\u533a\u5757\u94fe\u53d1\u7968"),
    TRANSPORT("y", "", "\u8fd0\u8f93\u4e1a\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968"),
    COMMON_ELECTRONIC("cd", "(^2\\d{9}11)|(^1\\d{9}00)", "\u901a\u7528(\u7535\u5b50)\u53d1\u7968"),
    SECOND_HAND_CAR("vs", "^0\\d{9}17", "\u4e8c\u624b\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968"),
    ELECTRONIC_INVOICE_QC("qc", "", "\u7535\u5b50\u53d1\u7968\uff08\u666e\u901a\u53d1\u7968\uff09"),
    ELECTRONIC_INVOICE_QS("qs", "", "\u7535\u5b50\u53d1\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09");

    private final String value;
    private final String regex;
    private final String description;

    private InvoiceTypeEnum(String value, String regex, String description) {
        this.value = value;
        this.regex = regex;
        this.description = description;
    }

    @Override
    public String value() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRegex() {
        return this.regex;
    }

    public static InvoiceTypeEnum fromValue(String value) {
        return Stream.of(InvoiceTypeEnum.values()).filter(t -> t.value().equals(value)).findFirst().orElse(null);
    }

    public static InvoiceTypeEnum fromMatchesInvoiceCode(String invoiceCode) {
        if (StringUtils.isEmpty((CharSequence)invoiceCode)) {
            return null;
        }
        return Stream.of(InvoiceTypeEnum.values()).filter(p -> invoiceCode.matches(p.getRegex())).findFirst().orElse(null);
    }
}

