/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.tools.redisson;

import com.xforceplus.phoenix.tools.enable.AutoConfiguration;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;

public class RedissonConfiguration
implements AutoConfiguration {
    @Value(value="${redis.type:standalone}")
    private String type;
    @Value(value="${redis.standaloneHost:127.0.0.1}")
    private String standaloneHost;
    @Value(value="${redis.standalonePort:6379}")
    private Integer standalonePort;
    @Value(value="${redis.maxActive:20}")
    private int maxActive;
    @Value(value="${redis.minIdle:5}")
    private Integer minIdle;
    @Value(value="${redis.maxTotal:}")
    private Integer maxTotal;
    @Value(value="${redis.maxWaitMillis:}")
    private Integer maxWaitMillis;
    @Value(value="${redis.minEvictableIdleTimeMillis:}")
    private Integer minEvictableIdleTimeMillis;
    @Value(value="${redis.numTestsPerEvictionRun:}")
    private Integer numTestsPerEvictionRun;
    @Value(value="${redis.testOnBorrow:true}")
    private boolean testOnBorrow;
    @Value(value="${redis.testWhileIdle:false}")
    private boolean testWhileIdle;
    @Value(value="${redis.sentinelNodes:}")
    private String sentinelNodes;
    @Value(value="${redis.sentinelMaster:}")
    private String sentinelMaster;
    @Value(value="${redis.password:}")
    private String password;
    @Value(value="${redis.connectTimeout:10000}")
    private int connectTimeout;
    @Value(value="${redis.timeout:3000}")
    private Integer timeout;
    @Value(value="${redis.clusterNodes:}")
    private String clusterNodes;

    @Bean
    public RedissonClient redissonClient() {
        Config config = new Config();
        String prefix = "redis://";
        String standaloneType = "standalone";
        if (Objects.equals(this.type, "standalone")) {
            String address = "redis://" + this.standaloneHost + ":" + this.standalonePort;
            SingleServerConfig singleServerConfig = (SingleServerConfig)((SingleServerConfig)config.useSingleServer().setAddress(address).setConnectionPoolSize(this.maxActive).setConnectionMinimumIdleSize(this.minIdle.intValue()).setConnectTimeout(this.connectTimeout)).setTimeout(this.timeout.intValue());
            if (StringUtils.isNotBlank((CharSequence)this.password)) {
                singleServerConfig.setPassword(this.password);
            }
        } else if (this.type.equals("cluster")) {
            String[] clusterNodeArray;
            StringBuilder clusterAddressBuilder = new StringBuilder();
            for (String node : clusterNodeArray = StringUtils.split((String)this.clusterNodes, (String)",")) {
                clusterAddressBuilder.append("redis://").append(node).append(",");
            }
            String clusterAddress = clusterAddressBuilder.toString();
            ClusterServersConfig clusterServersConfig = (ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)config.useClusterServers().addNodeAddress(new String[]{clusterAddress.substring(0, clusterAddress.length() - 1)}).setMasterConnectionPoolSize(this.maxActive)).setMasterConnectionMinimumIdleSize(this.minIdle.intValue())).setSlaveConnectionPoolSize(this.maxActive)).setSlaveConnectionMinimumIdleSize(this.minIdle.intValue())).setConnectTimeout(this.connectTimeout)).setTimeout(this.timeout.intValue());
            if (StringUtils.isNotBlank((CharSequence)this.password)) {
                clusterServersConfig.setPassword(this.password);
            }
        } else {
            String[] sentinelNodeArray;
            StringBuilder sentinelAddressBuilder = new StringBuilder();
            for (String node : sentinelNodeArray = StringUtils.split((String)this.sentinelNodes, (String)",")) {
                sentinelAddressBuilder.append("redis://").append(node).append(",");
            }
            String sentinelAddress = sentinelAddressBuilder.toString();
            SentinelServersConfig sentinelServersConfig = (SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)config.useSentinelServers().setMasterName(this.sentinelMaster).addSentinelAddress(new String[]{sentinelAddress.substring(0, sentinelAddress.length() - 1)}).setMasterConnectionPoolSize(this.maxActive)).setMasterConnectionMinimumIdleSize(this.minIdle.intValue())).setSlaveConnectionPoolSize(this.maxActive)).setSlaveConnectionMinimumIdleSize(this.minIdle.intValue())).setConnectTimeout(this.connectTimeout)).setTimeout(this.timeout.intValue());
            if (StringUtils.isNotBlank((CharSequence)this.password)) {
                sentinelServersConfig.setPassword(this.password);
            }
        }
        return Redisson.create((Config)config);
    }
}

