/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.tools.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public enum ByteUnitFormat {
    B(Unit.B){

        @Override
        long toB(long value, Rate rate) {
            return value;
        }
    }
    ,
    K(Unit.K){

        @Override
        long toB(long value, Rate rate) {
            return value * (long)rate.rate;
        }
    }
    ,
    M(Unit.M){

        @Override
        long toB(long value, Rate rate) {
            return value * (long)rate.rate * (long)rate.rate;
        }
    }
    ,
    G(Unit.G){

        @Override
        long toB(long value, Rate rate) {
            return value * (long)rate.rate * (long)rate.rate * (long)rate.rate;
        }
    }
    ,
    T(Unit.T){

        @Override
        long toB(long value, Rate rate) {
            return value * (long)rate.rate * (long)rate.rate * (long)rate.rate * (long)rate.rate;
        }
    }
    ,
    P(Unit.P){

        @Override
        long toB(long value, Rate rate) {
            return value * (long)rate.rate * (long)rate.rate * (long)rate.rate * (long)rate.rate * (long)rate.rate;
        }
    }
    ,
    E(Unit.E){

        @Override
        long toB(long value, Rate rate) {
            return value * (long)rate.rate * (long)rate.rate * (long)rate.rate * (long)rate.rate * (long)rate.rate * (long)rate.rate;
        }
    };

    private Unit unit;

    private ByteUnitFormat(Unit unit) {
        this.unit = unit;
    }

    public final String humanReadable(long value, Rate rate, int scale, RoundingMode roundingMode, boolean displayUnitName) {
        String suffix;
        long b = this.toB(value, rate);
        String string = suffix = displayUnitName ? ByteUnitFormat.B.unit.name : "";
        if (b < (long)rate.rate) {
            return b + suffix;
        }
        int level = (int)(Math.log(b) / Math.log(rate.rate));
        return B.to(ByteUnitFormat.values()[level], b, rate, scale, roundingMode, displayUnitName);
    }

    public final String humanReadable(long value, Rate rate, boolean displayUnitName) {
        return this.humanReadable(value, rate, 1, RoundingMode.HALF_UP, displayUnitName);
    }

    public final String humanReadable(long value, boolean displayUnitName) {
        return this.humanReadable(value, Rate.IEC, displayUnitName);
    }

    public final String humanReadable(long value) {
        return this.humanReadable(value, Rate.IEC, true);
    }

    public final String to(ByteUnitFormat targetFormat, long value, Rate rate) {
        return this.to(targetFormat, value, rate, 6, RoundingMode.HALF_UP, true);
    }

    public final String to(ByteUnitFormat targetFormat, long value) {
        return this.to(targetFormat, value, Rate.IEC, 6, RoundingMode.HALF_UP, true);
    }

    public final String to(ByteUnitFormat targetFormat, long value, Rate rate, int scale, RoundingMode roundingMode, boolean displayUnitName) {
        String suffix;
        int level = targetFormat.unit.ordinal() - this.unit.ordinal();
        DecimalFormat df = new DecimalFormat("#" + (scale > 0 ? "#." + ByteUnitFormat.repeat("#", scale) : ""));
        String string = suffix = displayUnitName ? targetFormat.unit.name : "";
        if (level == 0) {
            return value + suffix;
        }
        if (level > 0) {
            BigDecimal result = new BigDecimal(value);
            for (int i = 0; i < level; ++i) {
                result = result.divide(new BigDecimal(rate.rate), 8, roundingMode);
            }
            return df.format(result.setScale(scale, roundingMode).doubleValue()) + suffix;
        }
        level = Math.abs(level);
        BigDecimal result = new BigDecimal(value);
        for (int i = 0; i < level; ++i) {
            result = result.multiply(new BigDecimal(rate.rate));
        }
        return df.format(result.setScale(scale, roundingMode).doubleValue()) + suffix;
    }

    public static String repeat(String seq, int n) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            s.append(seq);
        }
        return s.toString();
    }

    abstract long toB(long var1, Rate var3);

    public static enum Rate {
        SI(1000),
        IEC(1024);

        private int rate;

        private Rate(int rate) {
            this.rate = rate;
        }
    }

    public static enum Unit {
        B("B"),
        K("K"),
        M("M"),
        G("G"),
        T("T"),
        P("P"),
        E("E");

        private String name;

        private Unit(String name) {
            this.name = name;
        }
    }
}

