/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.tools.util;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ExcelTools {
    public <T> List<T> importExcel(File file, String sheetName, Map<String, String> metaMap, Class<T> clazz, Integer limitNums) {
        Sheet sheet = this.getSheet(file, sheetName);
        return this.readExcelData(sheet, metaMap, clazz, limitNums);
    }

    private <T> List<T> readExcelData(Sheet sheet, Map<String, String> metaMap, Class<T> clazz, Integer limitNums) {
        ArrayList result = Lists.newArrayList();
        Row firstRow = sheet.getRow(0);
        ArrayList sheetColumnNameList = Lists.newArrayList();
        for (Cell cell : firstRow) {
            sheetColumnNameList.add(this.getCellValue(cell));
        }
        String[] sortedTableColumnNameList = new String[sheetColumnNameList.size()];
        int count = 0;
        for (String sheetColumnName : sheetColumnNameList) {
            for (String key : metaMap.keySet()) {
                if (!sheetColumnName.equals(metaMap.get(key))) continue;
                sortedTableColumnNameList[count] = key;
            }
            ++count;
        }
        int rowNo = 1;
        int colNo = 1;
        for (Row row : sheet) {
            if (rowNo == 1) {
                ++rowNo;
                continue;
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.getCellValue(row.getCell(0))) && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.getCellValue(row.getCell(1)))) break;
            if (Map.class.isAssignableFrom(clazz)) {
                HashMap map = Maps.newHashMap();
                for (Cell cell : row) {
                    String cellValue = this.getCellValue(cell);
                    String cellName = sortedTableColumnNameList[cell.getColumnIndex()];
                    if (StringUtils.isEmpty((Object)cellName)) continue;
                    map.put(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, cellName), cellValue);
                }
                result.add(map);
            } else {
                try {
                    T obj = clazz.newInstance();
                    for (Cell cell : row) {
                        if (sortedTableColumnNameList.length - 1 < cell.getColumnIndex()) continue;
                        String cellName = sortedTableColumnNameList[cell.getColumnIndex()];
                        if (!StringUtils.isEmpty((Object)cellName)) {
                            try {
                                Field field = clazz.getDeclaredField(cellName);
                                field.setAccessible(true);
                                field.set(obj, this.getFieldValue(field, cell));
                            }
                            catch (NoSuchFieldException e) {
                                e.printStackTrace();
                                throw new RuntimeException("\u63d0\u793a\uff1a\u5bf9\u8c61\u7c7b\u578b\u4e0d\u5b58\u5728\u8be5\u5b57\u6bb5" + cellName);
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException("\u63d0\u793a\uff1a\u83b7\u53d6\u4f20\u5165\u5bf9\u8c61\u7c7b\u578b\u7684\u5c5e\u6027\u5931\u8d25.");
                            }
                        }
                        ++colNo;
                    }
                    result.add(obj);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    throw new RuntimeException("\u63d0\u793a\uff1a\u4f20\u5165\u7684\u5bf9\u8c61\u7c7b\u578b\u5b9e\u4f8b\u5316\u5931\u8d25.[" + e.getMessage() + "]");
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    throw new RuntimeException("\u7b2c" + rowNo + "\u884c\u7b2c" + colNo + "\u5217,\u83b7\u53d6\u4f20\u5165\u5bf9\u8c61\u7c7b\u578b\u7684\u5c5e\u6027\u5931\u8d25.[" + e.getMessage() + "]");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("\u7b2c" + rowNo + "\u884c\u7b2c" + colNo + "\u5217,\u89e3\u6790\u6570\u636e\u5931\u8d25.[" + e.getMessage() + "]");
                }
            }
            if (null == limitNums || ++rowNo < limitNums + 3) continue;
            throw new RuntimeException("\u5bfc\u5165\u5931\u8d25,\u5355\u6b21\u4e0a\u4f20\u4e0a\u9650\u4e3a" + limitNums + "\u6761,\u60a8\u5df2\u8d85\u9650");
        }
        return result;
    }

    private Sheet getSheet(File file, String sheetName) {
        Workbook wb = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            wb = WorkbookFactory.create((InputStream)inputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException("\u63d0\u793a\uff1a\u672a\u83b7\u5f97\u4f20\u5165\u7684\u6587\u4ef6,\u8bf7\u5237\u65b0\u9875\u9762,\u91cd\u65b0\u9009\u62e9\u6587\u4ef6\u4e0a\u4f20.");
        }
        catch (InvalidFormatException e) {
            e.printStackTrace();
            throw new RuntimeException("\u63d0\u793a\uff1a\u4e0d\u662f\u6709\u6548\u7684Excel\u6587\u4ef6,\u8bf7\u5237\u65b0\u9875\u9762,\u91cd\u65b0\u9009\u62e9\u6587\u4ef6\u4e0a\u4f20.");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u63d0\u793a\uff1a\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u67e5\u9605\u62a5\u9519\u65e5\u5fd7.");
        }
        finally {
            try {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Sheet sheet = wb.getSheet(sheetName);
        if (sheet == null) {
            throw new RuntimeException("\u63d0\u793a:\u5904\u7406\u5931\u8d25,\u6587\u4ef6\u4e2d\u672a\u627e\u5230[" + sheetName + "]sheet\u9875.");
        }
        return sheet;
    }

    private String getCellValue(Cell cell) {
        String ret = "";
        try {
            if (null == cell) {
                return ret;
            }
            switch (cell.getCellType()) {
                case 4: {
                    ret = String.valueOf(cell.getBooleanCellValue());
                    break;
                }
                case 0: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        double d = cell.getNumericCellValue();
                        Date date = DateUtil.getJavaDate((double)d);
                        ret = new SimpleDateFormat("yyyy-MM-dd").format(date);
                        break;
                    }
                    Long temp = Math.round(cell.getNumericCellValue());
                    ret = Double.parseDouble(temp + ".0") == cell.getNumericCellValue() ? String.valueOf(temp) : ExcelTools.getPlainString(String.valueOf(cell.getNumericCellValue()));
                    break;
                }
                case 1: {
                    ret = cell.getStringCellValue().trim();
                    break;
                }
                case 2: {
                    try {
                        ret = DateUtil.isCellDateFormatted((Cell)cell) ? new SimpleDateFormat("yyyy-MM-dd").format(cell.getDateCellValue()) : this.parseFormula(cell);
                    }
                    catch (Exception e) {
                        ret = String.valueOf(cell.getRichStringCellValue());
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u4e2d\u5b58\u5728\u5355\u5143\u683c\u683c\u5f0f\u4e0d\u6b63\u786e\u7b49\u95ee\u9898,\u6570\u636e\u6709\u8bef,\u8bf7\u68c0\u67e5\u6587\u4ef6\u4e2d\u516c\u5f0f\u7b49\u662f\u5426\u5b58\u5728\u5f15\u7528\u5931\u6548\u7b49\u95ee\u9898");
        }
        return ret;
    }

    private String parseFormula(Cell cell) {
        FormulaEvaluator evaluator = cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
        CellValue cellValue = evaluator.evaluate(cell);
        String ret = "";
        switch (cellValue.getCellType()) {
            case 4: {
                ret = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    double d = cell.getNumericCellValue();
                    Date date = DateUtil.getJavaDate((double)d);
                    ret = new SimpleDateFormat("yyyy-MM-dd").format(date);
                    break;
                }
                Long temp = Math.round(cell.getNumericCellValue());
                ret = Double.parseDouble(temp + ".0") == cell.getNumericCellValue() ? String.valueOf(temp) : ExcelTools.getPlainString(String.valueOf(cell.getNumericCellValue()));
                break;
            }
            case 1: {
                ret = cell.getStringCellValue().trim();
            }
        }
        return ret;
    }

    private Object getFieldValue(Field field, Cell cell) {
        if (BigDecimal.class.isAssignableFrom(field.getType())) {
            if (cell.getCellType() == 1) {
                return BigDecimal.valueOf(Double.parseDouble(cell.getStringCellValue()));
            }
            return BigDecimal.valueOf(cell.getNumericCellValue());
        }
        if (Boolean.class.isAssignableFrom(field.getType())) {
            return cell.getBooleanCellValue();
        }
        if (Integer.class.isAssignableFrom(field.getType())) {
            Long temp = Math.round(cell.getNumericCellValue());
            return temp.intValue();
        }
        if (Double.class.isAssignableFrom(field.getType())) {
            return cell.getNumericCellValue();
        }
        return this.getCellValue(cell);
    }

    public static String getPlainString(String value) {
        BigDecimal bd = new BigDecimal(value);
        return bd.toPlainString();
    }
}

