/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.tools.util;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFPrintSetup;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.util.CollectionUtils;

public class ExcelUtil {
    public static final Integer ALIGN_CENTER = 1;
    public static final Integer ALIGN_RIGHT = 2;

    public static SXSSFWorkbook createSXSSFWorkbook(String sheetName, List<String> titles, List<Integer> alignList, List<String[]> contents, SXSSFWorkbook workbook) {
        workbook = workbook == null ? new SXSSFWorkbook() : workbook;
        SXSSFSheet sheet = workbook.createSheet(sheetName);
        PrintSetup printSetup = sheet.getPrintSetup();
        printSetup.setLandscape(false);
        Font normalFont = workbook.createFont();
        normalFont.setFontName("Arial");
        normalFont.setFontHeightInPoints((short)12);
        normalFont.setBold(true);
        Font boldFont = workbook.createFont();
        boldFont.setFontName("Arial");
        boldFont.setFontHeightInPoints((short)10);
        boldFont.setBold(true);
        boldFont.setColor(HSSFColor.VIOLET.index);
        CellStyle hcs_center = workbook.createCellStyle();
        hcs_center.setAlignment(HorizontalAlignment.CENTER);
        hcs_center.setVerticalAlignment(VerticalAlignment.CENTER);
        hcs_center.setWrapText(false);
        hcs_center.setFillForegroundColor(IndexedColors.SKY_BLUE.index);
        hcs_center.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        hcs_center.setBorderBottom(BorderStyle.THIN);
        hcs_center.setBorderLeft(BorderStyle.THIN);
        hcs_center.setBorderRight(BorderStyle.THIN);
        hcs_center.setBorderTop(BorderStyle.THIN);
        CellStyle ctt_center = workbook.createCellStyle();
        ctt_center.setAlignment(HorizontalAlignment.CENTER);
        ctt_center.setVerticalAlignment(VerticalAlignment.CENTER);
        ctt_center.setWrapText(false);
        ctt_center.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.index);
        ctt_center.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        ctt_center.setBorderBottom(BorderStyle.THIN);
        ctt_center.setBorderLeft(BorderStyle.THIN);
        ctt_center.setBorderRight(BorderStyle.THIN);
        ctt_center.setBorderTop(BorderStyle.THIN);
        CellStyle ctt_right = workbook.createCellStyle();
        ctt_right.setAlignment(HorizontalAlignment.RIGHT);
        ctt_right.setVerticalAlignment(VerticalAlignment.CENTER);
        ctt_right.setWrapText(false);
        ctt_right.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.index);
        ctt_right.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        ctt_right.setBorderBottom(BorderStyle.THIN);
        ctt_right.setBorderLeft(BorderStyle.THIN);
        ctt_right.setBorderRight(BorderStyle.THIN);
        ctt_right.setBorderTop(BorderStyle.THIN);
        Row row = sheet.createRow(0);
        Cell cell = null;
        int titleLen = titles.size();
        HashMap<Integer, CellStyle> alignMap = new HashMap<Integer, CellStyle>(titleLen);
        for (int i = 0; i < titleLen; ++i) {
            cell = row.createCell(i);
            cell.setCellValue(titles.get(i));
            cell.setCellStyle(hcs_center);
            cell.setCellType(1);
            try {
                if ("\u53d1\u7968\u5e8f\u53f7".equals(titles.get(i))) {
                    sheet.setColumnWidth(i, titles.get(i).getBytes("utf-8").length * 256);
                } else if ("\u7a0e\u989d".equals(titles.get(i)) || "\u6570\u91cf".equals(titles.get(i))) {
                    sheet.setColumnWidth(i, titles.get(i).getBytes("utf-8").length * 3 * 256);
                } else {
                    sheet.setColumnWidth(i, titles.get(i).getBytes("utf-8").length * 2 * 256);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            CellStyle cellStyle = workbook.createCellStyle();
            DataFormat dataFormat = workbook.createDataFormat();
            cellStyle.setDataFormat(dataFormat.getFormat("@"));
            cell.setCellStyle(cellStyle);
            if (CollectionUtils.isEmpty(alignList) || alignList.size() <= i) {
                alignMap.put(i, ctt_center);
                continue;
            }
            if (ALIGN_RIGHT.equals(alignList.get(i))) {
                alignMap.put(i, ctt_right);
                continue;
            }
            alignMap.put(i, ctt_center);
        }
        int contentLen = contents.size();
        String[] rowContent = null;
        String content = "";
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.RIGHT);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setWrapText(false);
        cellStyle.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.index);
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        DataFormat format = workbook.createDataFormat();
        cellStyle.setDataFormat(format.getFormat("0.00"));
        for (int i = 0; i < contentLen; ++i) {
            row = sheet.createRow(i + 1);
            rowContent = contents.get(i);
            for (int j = 0; j < titleLen; ++j) {
                if (j < rowContent.length) {
                    content = rowContent[j];
                }
                cell = row.createCell(j);
                cell.setCellStyle((CellStyle)alignMap.get(j));
                if ("\u542b\u7a0e\u91d1\u989d".equals(titles.get(j)) || "\u7a0e\u989d".equals(titles.get(j)) || "\u4e0d\u542b\u7a0e\u91d1\u989d".equals(titles.get(j)) || "\u6570\u91cf".equals(titles.get(j)) || "\u4e0d\u542b\u7a0e\u5355\u4ef7".equals(titles.get(j)) || "\u4e0d\u542b\u7a0e\u6298\u6263\u91d1\u989d".equals(titles.get(j)) || "\u6298\u6263\u7a0e\u989d".equals(titles.get(j)) || "\u542b\u7a0e\u6298\u6263\u91d1\u989d".equals(titles.get(j)) || "\u8f6c\u51fa\u91d1\u989d".equals(titles.get(j)) || "\u4ed8\u6b3e\u91d1\u989d".equals(titles.get(j)) || "\u6709\u6548\u7a0e\u989d".equals(titles.get(j))) {
                    cell.setCellStyle(cellStyle);
                    if (!StringUtils.isNotEmpty((CharSequence)content)) continue;
                    cell.setCellValue(Double.parseDouble(content));
                    continue;
                }
                cell.setCellValue(content);
            }
        }
        return workbook;
    }

    public static XSSFWorkbook createXSSFWorkbook(String sheetName, List<String> titles, List<Integer> alignList, List<String[]> contents, Map<String, String> headAnnotations) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet(sheetName);
        XSSFPrintSetup printSetup = sheet.getPrintSetup();
        printSetup.setLandscape(false);
        XSSFFont normalFont = workbook.createFont();
        normalFont.setFontName("Arial");
        normalFont.setFontHeightInPoints((short)12);
        normalFont.setBold(true);
        XSSFFont boldFont = workbook.createFont();
        boldFont.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        boldFont.setFontHeightInPoints((short)10);
        boldFont.setBold(true);
        boldFont.setColor(HSSFColor.BLACK.index);
        XSSFDataFormat dataFormat = workbook.createDataFormat();
        short textFormat = dataFormat.getFormat("@");
        XSSFCellStyle hcs_center = workbook.createCellStyle();
        hcs_center.setAlignment(HorizontalAlignment.CENTER);
        hcs_center.setVerticalAlignment(VerticalAlignment.CENTER);
        hcs_center.setWrapText(false);
        hcs_center.setFillForegroundColor(IndexedColors.SKY_BLUE.index);
        hcs_center.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        hcs_center.setBorderBottom(BorderStyle.THIN);
        hcs_center.setBorderLeft(BorderStyle.THIN);
        hcs_center.setBorderRight(BorderStyle.THIN);
        hcs_center.setBorderTop(BorderStyle.THIN);
        hcs_center.setFont((Font)boldFont);
        hcs_center.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.index);
        hcs_center.setDataFormat(textFormat);
        XSSFCellStyle ctt_center = workbook.createCellStyle();
        ctt_center.setAlignment(HorizontalAlignment.CENTER);
        ctt_center.setVerticalAlignment(VerticalAlignment.CENTER);
        ctt_center.setWrapText(false);
        ctt_center.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.index);
        ctt_center.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        ctt_center.setBorderBottom(BorderStyle.THIN);
        ctt_center.setBorderLeft(BorderStyle.THIN);
        ctt_center.setBorderRight(BorderStyle.THIN);
        ctt_center.setBorderTop(BorderStyle.THIN);
        ctt_center.setDataFormat(textFormat);
        XSSFCellStyle ctt_right = workbook.createCellStyle();
        ctt_right.setAlignment(HorizontalAlignment.RIGHT);
        ctt_right.setVerticalAlignment(VerticalAlignment.CENTER);
        ctt_right.setWrapText(false);
        ctt_right.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.index);
        ctt_right.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        ctt_right.setBorderBottom(BorderStyle.THIN);
        ctt_right.setBorderLeft(BorderStyle.THIN);
        ctt_right.setBorderRight(BorderStyle.THIN);
        ctt_right.setBorderTop(BorderStyle.THIN);
        XSSFDrawing drawingPatriarch = sheet.createDrawingPatriarch();
        XSSFRow row = sheet.createRow(0);
        Cell cell = null;
        int titleLen = titles.size();
        HashMap<Integer, XSSFCellStyle> alignMap = new HashMap<Integer, XSSFCellStyle>(titleLen);
        for (int i = 0; i < titleLen; ++i) {
            String titleText = titles.get(i);
            cell = row.createCell(i);
            cell.setCellValue(titleText);
            cell.setCellStyle((CellStyle)hcs_center);
            cell.setCellType(1);
            if (null != headAnnotations && headAnnotations.containsKey(titleText)) {
                String annotationText = headAnnotations.get(titleText);
                XSSFComment comment = drawingPatriarch.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, 3, 3, 4, 4));
                comment.setString((RichTextString)new XSSFRichTextString(annotationText));
                cell.setCellComment((Comment)comment);
            }
            try {
                sheet.setColumnWidth(i, titles.get(i).getBytes("utf-8").length * 2 * 256);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (CollectionUtils.isEmpty(alignList) || alignList.size() <= i) {
                alignMap.put(i, ctt_center);
                continue;
            }
            if (ALIGN_RIGHT.equals(alignList.get(i))) {
                alignMap.put(i, ctt_right);
                continue;
            }
            alignMap.put(i, ctt_center);
        }
        int contentLen = contents.size();
        String[] rowContent = null;
        String content = "";
        for (int i = 0; i < contentLen; ++i) {
            row = sheet.createRow(i + 1);
            rowContent = contents.get(i);
            for (int j = 0; j < titleLen; ++j) {
                if (j < rowContent.length) {
                    content = rowContent[j];
                }
                cell = row.createCell(j);
                cell.setCellStyle((CellStyle)alignMap.get(j));
                cell.setCellValue(content);
            }
        }
        return workbook;
    }

    public static SXSSFWorkbook createSXSSFWorkbookWithBillInvoice(String sheetName, List<String> titles, List<Integer> alignList, List<String[]> contents, SXSSFWorkbook workbook, Integer billAndInvoiceBorder) {
        workbook = workbook == null ? new SXSSFWorkbook() : workbook;
        SXSSFSheet sheet = workbook.createSheet(sheetName);
        PrintSetup printSetup = sheet.getPrintSetup();
        printSetup.setLandscape(false);
        Font normalFont = workbook.createFont();
        normalFont.setFontName("Arial");
        normalFont.setFontHeightInPoints((short)12);
        normalFont.setBold(true);
        Font boldFont = workbook.createFont();
        boldFont.setFontName("Arial");
        boldFont.setFontHeightInPoints((short)10);
        boldFont.setBold(true);
        boldFont.setColor(HSSFColor.VIOLET.index);
        DataFormat format = workbook.createDataFormat();
        CellStyle billTitle = workbook.createCellStyle();
        billTitle.setAlignment(HorizontalAlignment.CENTER);
        billTitle.setVerticalAlignment(VerticalAlignment.CENTER);
        billTitle.setWrapText(false);
        billTitle.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.index);
        billTitle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        billTitle.setBorderBottom(BorderStyle.THIN);
        billTitle.setBorderLeft(BorderStyle.THIN);
        billTitle.setBorderRight(BorderStyle.THIN);
        billTitle.setBorderTop(BorderStyle.THIN);
        billTitle.setDataFormat(format.getFormat("0.00"));
        CellStyle invoiceTitle = workbook.createCellStyle();
        invoiceTitle.setAlignment(HorizontalAlignment.RIGHT);
        invoiceTitle.setVerticalAlignment(VerticalAlignment.CENTER);
        invoiceTitle.setWrapText(false);
        invoiceTitle.setFillForegroundColor(IndexedColors.LIGHT_GREEN.index);
        invoiceTitle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        invoiceTitle.setBorderBottom(BorderStyle.THIN);
        invoiceTitle.setBorderLeft(BorderStyle.THIN);
        invoiceTitle.setBorderRight(BorderStyle.THIN);
        invoiceTitle.setBorderTop(BorderStyle.THIN);
        invoiceTitle.setDataFormat(format.getFormat("0.00"));
        CellStyle billStyle = workbook.createCellStyle();
        billStyle.setAlignment(HorizontalAlignment.RIGHT);
        billStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        billStyle.setWrapText(false);
        billStyle.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.index);
        billStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        billStyle.setBorderBottom(BorderStyle.THIN);
        billStyle.setBorderLeft(BorderStyle.THIN);
        billStyle.setBorderRight(BorderStyle.THIN);
        billStyle.setBorderTop(BorderStyle.THIN);
        billStyle.setDataFormat(format.getFormat("0.00"));
        CellStyle invoiceStyle = workbook.createCellStyle();
        invoiceStyle.setAlignment(HorizontalAlignment.RIGHT);
        invoiceStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        invoiceStyle.setWrapText(false);
        invoiceStyle.setFillForegroundColor(IndexedColors.LIGHT_GREEN.index);
        invoiceStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        invoiceStyle.setBorderBottom(BorderStyle.THIN);
        invoiceStyle.setBorderLeft(BorderStyle.THIN);
        invoiceStyle.setBorderRight(BorderStyle.THIN);
        invoiceStyle.setBorderTop(BorderStyle.THIN);
        invoiceStyle.setDataFormat(format.getFormat("0.00"));
        Row row = sheet.createRow(0);
        Cell cell = null;
        int titleLen = titles.size();
        HashMap alignMap = new HashMap(titleLen);
        for (int i = 0; i < titleLen; ++i) {
            cell = row.createCell(i);
            cell.setCellValue(titles.get(i));
            cell.setCellType(1);
            try {
                if ("\u7a0e\u989d".equals(titles.get(i))) {
                    sheet.setColumnWidth(i, titles.get(i).getBytes("utf-8").length * 3 * 256);
                } else {
                    sheet.setColumnWidth(i, titles.get(i).getBytes("utf-8").length * 2 * 256);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (i < billAndInvoiceBorder) {
                cell.setCellStyle(billTitle);
                continue;
            }
            cell.setCellStyle(invoiceTitle);
        }
        int contentLen = contents.size();
        String[] rowContent = null;
        String content = "";
        for (int i = 0; i < contentLen; ++i) {
            row = sheet.createRow(i + 1);
            rowContent = contents.get(i);
            for (int j = 0; j < titleLen; ++j) {
                if (j < rowContent.length) {
                    content = rowContent[j];
                }
                cell = row.createCell(j);
                if (j < billAndInvoiceBorder) {
                    cell.setCellStyle(billStyle);
                } else {
                    cell.setCellStyle(invoiceStyle);
                }
                if ("\u542b\u7a0e\u91d1\u989d".equals(titles.get(j)) || "\u7a0e\u989d".equals(titles.get(j)) || "\u4e0d\u542b\u7a0e\u91d1\u989d".equals(titles.get(j)) || "\u5df2\u5339\u914d\u91d1\u989d".equals(titles.get(j)) || "\u5e94\u4ed8\u91d1\u989d".equals(titles.get(j)) || "\u672c\u6b21\u5360\u7528\u91d1\u989d".equals(titles.get(j)) || "\u5269\u4f59\u5360\u7528\u91d1\u989d".equals(titles.get(j)) || "\u672c\u6b21\u5360\u7528\u7a0e\u989d".equals(titles.get(j))) {
                    if (!StringUtils.isNotEmpty((CharSequence)content)) continue;
                    cell.setCellValue(Double.parseDouble(content));
                    continue;
                }
                cell.setCellValue(content);
            }
        }
        return workbook;
    }
}

