/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.tools.util;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public final class StrUtil {
    static final String commaRegex = ",|\uff0c";

    private StrUtil() {
    }

    public static String subLast(String str, int length) {
        int strLength = StringUtils.length((CharSequence)str);
        if (strLength == 0) {
            return null;
        }
        return StringUtils.substring((String)str, (int)(strLength > length ? strLength - length : 0));
    }

    public static boolean strCompare(String s1, String s2) {
        if (StringUtils.isEmpty((CharSequence)s1)) {
            s1 = "";
        }
        if (StringUtils.isEmpty((CharSequence)s2)) {
            s2 = "";
        }
        return StrUtil.discombobulate(s1).equals(StrUtil.discombobulate(s2));
    }

    private static String discombobulate(String s) {
        String REGEX = "[^0-9a-zA-Z\u4e00-\u9fa5.\uff0c,\u3002\uff1f\u201c\u201d]+";
        return s.replaceAll(REGEX, "").toLowerCase();
    }

    public static List<String> strSplit(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return Lists.newArrayList();
        }
        return Stream.of(str.split(commaRegex)).collect(Collectors.toList());
    }
}

