/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.tools.event;

import com.google.common.eventbus.Subscribe;
import com.xforceplus.phoenix.tools.event.BaseCustomEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractCustomEventHandler<CustomEvent extends BaseCustomEvent> {
    private static final Logger log = LoggerFactory.getLogger(AbstractCustomEventHandler.class);
    private static final String methodName = "onSubScribe";

    @Subscribe
    public void onEvent(BaseCustomEvent event) {
        if (ReflectionUtils.findMethod(this.getClass(), (String)methodName, (Class[])new Class[]{event.getClass()}) != null) {
            try {
                if (!this.onSubScribe(event)) {
                    log.warn("custom event handle event {} fail", event.getClass());
                }
            }
            catch (Exception e) {
                log.error("custom event handle event {} {}", event.getClass(), (Object)e);
            }
        }
    }

    public abstract boolean onSubScribe(CustomEvent var1);
}

