/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.tools.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaxRateUtil {
    private static final Logger log = LoggerFactory.getLogger(TaxRateUtil.class);
    private static final String REGEX = "%|\\s";
    private static final BigDecimal HUNDRED = new BigDecimal(100);
    private static final DecimalFormat FORMAT = new DecimalFormat("#0.00");

    public static String formatDivide(String textRate) {
        if (StringUtils.isBlank((CharSequence)textRate)) {
            return textRate;
        }
        String textRateNumber = textRate.replaceAll(REGEX, "");
        if (NumberUtils.isCreatable((String)textRateNumber)) {
            BigDecimal rate = new BigDecimal(textRateNumber);
            rate = rate.compareTo(BigDecimal.ONE) < 0 ? rate : rate.divide(HUNDRED);
            return FORMAT.format(rate);
        }
        return textRate;
    }

    public static String formatMultiply(String formatRate) {
        if (StringUtils.isBlank((CharSequence)formatRate)) {
            return formatRate;
        }
        String rateAmount = TaxRateUtil.getAmount(formatRate);
        if (!NumberUtils.isCreatable((String)rateAmount)) {
            return formatRate;
        }
        BigDecimal rate = new BigDecimal(rateAmount);
        try {
            rate = rate.compareTo(BigDecimal.ONE) < 0 ? rate.multiply(HUNDRED).setScale(0) : rate;
            return rate.toString();
        }
        catch (Exception e) {
            log.error("formatMultiply error formatRate:{}", (Object)formatRate, (Object)e);
            return formatRate;
        }
    }

    public static String getAmount(String str) {
        Matcher matcher = Pattern.compile("\\d+\\.\\d+").matcher(str);
        return matcher.find() ? matcher.group() : str;
    }

    private TaxRateUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

