/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.tools.event;

import com.xforceplus.phoenix.tools.enable.AutoConfiguration;
import com.xforceplus.phoenix.tools.event.AbstractCustomEventHandler;
import com.xforceplus.phoenix.tools.event.AsyncCustomEvent;
import com.xforceplus.phoenix.tools.event.EventBusPublisher;
import com.xforceplus.phoenix.tools.util.SpringContextUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class EventAutoConfiguration
implements InitializingBean,
DisposableBean,
AutoConfiguration {
    private Map<String, AbstractCustomEventHandler> beans = null;

    public void afterPropertiesSet() throws Exception {
        this.beans = SpringContextUtil.getBeansOfType(AbstractCustomEventHandler.class);
        if (this.beans != null) {
            for (AbstractCustomEventHandler eventAbstract : this.beans.values()) {
                EventBusPublisher.register(eventAbstract, this.getExecutor(eventAbstract));
            }
        }
    }

    public void destroy() throws Exception {
        if (this.beans != null) {
            for (AbstractCustomEventHandler eventAbstract : this.beans.values()) {
                EventBusPublisher.unregister(eventAbstract, this.getExecutor(eventAbstract));
            }
        }
    }

    private Executor getExecutor(AbstractCustomEventHandler eventAbstract) {
        Type event;
        AsyncCustomEvent asyncEvent;
        Type genericSuperclass = eventAbstract.getClass().getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType && null != (asyncEvent = ((Class)(event = ((ParameterizedType)genericSuperclass).getActualTypeArguments()[0])).getAnnotation(AsyncCustomEvent.class))) {
            return SpringContextUtil.getBean(asyncEvent.beanName(), Executor.class);
        }
        return null;
    }
}

