/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.tools.util;

import com.google.common.collect.Maps;
import com.xforceplus.phoenix.tools.util.AppIdDefiner;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class PropertiesUtil {
    private static final Map<String, Properties> propertiesMap = Maps.newHashMap();

    private PropertiesUtil() {
    }

    public static String getString(String propertiesPath, String key) {
        return PropertiesUtil.getString(propertiesPath, key, "");
    }

    public static String getString(String propertiesPath, String key, String defaultValue) {
        Properties properties = propertiesMap.get(propertiesPath);
        if (properties == null) {
            properties = PropertiesUtil.get(propertiesPath);
        }
        return properties != null ? properties.getProperty(key, defaultValue) : defaultValue;
    }

    private static synchronized Properties get(String propertiesPath) {
        Properties properties = propertiesMap.get(propertiesPath);
        if (properties != null) {
            propertiesMap.put(propertiesPath, properties);
            return properties;
        }
        properties = PropertiesUtil.load(propertiesPath);
        if (properties != null) {
            propertiesMap.put(propertiesPath, properties);
            return properties;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties load(String propertiesPath) {
        InputStream in = null;
        try {
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertiesPath);
            if (in == null) {
                in = AppIdDefiner.class.getResourceAsStream(propertiesPath);
            }
            if (in != null) {
                Properties prop = new Properties();
                prop.load(in);
                Properties properties = prop;
                return properties;
            }
            Properties properties = null;
            return properties;
        }
        catch (Exception e) {
            Properties properties = null;
            return properties;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

