/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.tools.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public final class TextRateUtil {
    private static final String REGEX = "%|\\s";
    private static final BigDecimal HUNDRED = new BigDecimal(100);
    private static final DecimalFormat FORMAT = new DecimalFormat("#0.00");

    public static String format(String textRate) {
        if (StringUtils.isBlank((CharSequence)textRate)) {
            return textRate;
        }
        String textRateNumber = textRate.replaceAll(REGEX, "");
        if (NumberUtils.isCreatable((String)textRateNumber)) {
            BigDecimal rate = new BigDecimal(textRateNumber);
            rate = rate.compareTo(BigDecimal.ONE) < 0 ? rate : rate.divide(HUNDRED);
            return FORMAT.format(rate);
        }
        return textRate;
    }

    public static void main(String[] args) {
        String format = TextRateUtil.format("0.13");
        System.out.println(format);
        String format2 = TextRateUtil.format("13");
        System.out.println(format2);
        String format3 = TextRateUtil.format("13.00");
        System.out.println(format3);
        String format4 = TextRateUtil.format("13%");
        System.out.println(format4);
        String format5 = TextRateUtil.format("13.00%");
        System.out.println(format5);
        String format6 = TextRateUtil.format("0");
        System.out.println(format6);
        String format7 = TextRateUtil.format("*");
        System.out.println(format7);
    }

    private TextRateUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

