package com.xforceplus.phoenix.tools.enums;

import com.xforceplus.phoenix.tools.enums.base.IEnumIntValue;

/**
 * @program: phoenix-purchaser-tools
 * @description: 审核状态枚举
 * @author: cuixiangyu
 * @created: 2020-05-07 10:12
 */
public enum AuditStatusEnum implements IEnumIntValue {
    /**
     * 未付款
     */
    NOT_AUDIT(0,"未审核"),
    /**
     * 部分付款
     */
    SUCCESS_AUDIT(1,"审核通过"),
    /**
     * 已付款
     */
    FAIL_AUDIT(2,"审核不通过"),
    ;

    private final Integer value;
    private final String description;

    AuditStatusEnum(Integer value, String description) {
        this.value = value;
        this.description = description;
    }

    @Override
    public Integer value() {
        return this.value;
    }

    public String getDescription() {
        return description;
    }
}
