package com.xforceplus.phoenix.tools.enums;

import java.util.Arrays;

/**
 * 抵扣用途：1：抵扣勾选，2：不抵扣勾选
 * Created by xiezhongyong on 2019/8/31.
 */
public enum AuthUseEnum {

    DEFAULT(0,"默认值"),

    CHECK(1, "抵扣勾选"),

    NO_CHECK(2,"不抵扣勾选"),

    REMOVE_CHECK(10, "撤销勾选"),

    REMOVE_NO_CHECK(20, "撤销不抵扣勾选"),

    DRAWBACK_CHECK(3,"退税勾选"),

    REMOVE_DRAWBACK_CHECK(30,"撤销退税勾选");

    private Integer code;
    private String message;

    AuthUseEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public Integer value() {
        return this.code;
    }

    public String message() {
        return this.message;
    }

    public static AuthUseEnum fromValue(Integer code) {
        return Arrays.stream(AuthUseEnum.values())
                .filter(s -> s.value().equals(code))
                .findAny()
                .orElse(null);
    }
}
